/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MenuMatrix {
    private final List<String> labels = new ArrayList<String>();
    private final Map<Character, ItemStack> itemStackMap = new HashMap<Character, ItemStack>();
    private final Map<Character, ChestMenu.MenuClickHandler> handlerMap = new HashMap<Character, ChestMenu.MenuClickHandler>();

    @NotNull
    public MenuMatrix addLine(String label) {
        this.labels.add(label);
        return this;
    }

    @NotNull
    public MenuMatrix addLine(String ... labels) {
        for (String label : labels) {
            this.addLine(label);
        }
        return this;
    }

    @NotNull
    public MenuMatrix addLine(@NotNull List<String> labels) {
        for (String label : labels) {
            this.addLine(label);
        }
        return this;
    }

    @NotNull
    public MenuMatrix addItem(Character label, ItemStack item, ChestMenu.MenuClickHandler handler) {
        this.itemStackMap.put(label, item);
        this.handlerMap.put(label, handler);
        return this;
    }

    @NotNull
    public MenuMatrix addItem(Character label, ItemStack item) {
        return this.addItem(label, item, (p, s, i, a) -> false);
    }

    @NotNull
    public MenuMatrix addHandler(Character label, ChestMenu.MenuClickHandler handler) {
        this.handlerMap.put(label, handler);
        return this;
    }

    @NotNull
    public MenuMatrix addItem(@NotNull String label, ItemStack item, ChestMenu.MenuClickHandler handler) {
        return this.addItem(Character.valueOf(label.charAt(0)), item, handler);
    }

    @NotNull
    public MenuMatrix addItem(@NotNull String label, ItemStack item) {
        return this.addItem(Character.valueOf(label.charAt(0)), item, (p, s, i, a) -> false);
    }

    @NotNull
    public MenuMatrix addHandler(@NotNull String label, ChestMenu.MenuClickHandler handler) {
        return this.addHandler(Character.valueOf(label.charAt(0)), handler);
    }

    public void build(@NotNull BlockMenuPreset preset) {
        int index = 0;
        for (String label : this.labels) {
            for (int j = 0; j < label.length() && index < 54; ++index, ++j) {
                char c = label.charAt(j);
                if (!this.itemStackMap.containsKey(Character.valueOf(c))) continue;
                preset.addItem(index, this.itemStackMap.get(Character.valueOf(c)), this.handlerMap.get(Character.valueOf(c)));
            }
        }
    }

    public int getChar(Character label) {
        for (int i = 0; i < this.labels.size(); ++i) {
            String line = this.labels.get(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != label.charValue()) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    public int getChar(@NotNull String label) {
        return this.getChar(Character.valueOf(label.charAt(0)));
    }

    public int[] getChars(Character label) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.labels.size(); ++i) {
            String line = this.labels.get(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != label.charValue()) continue;
                result.add(i * 9 + j);
            }
        }
        int[] array = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            array[i] = (Integer)result.get(i);
        }
        return array;
    }

    public int[] getChars(@NotNull String label) {
        return this.getChars(Character.valueOf(label.charAt(0)));
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Map<Character, ItemStack> getItemStackMap() {
        return this.itemStackMap;
    }

    @Generated
    public Map<Character, ChestMenu.MenuClickHandler> getHandlerMap() {
        return this.handlerMap;
    }
}

