/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.emctech;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.PatchEvent;
import com.balugaq.jeg.core.integrations.emctech.EMCTechIntegrationMain;
import com.balugaq.jeg.core.integrations.emctech.EMCValueDisplayOption;
import com.balugaq.jeg.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMCItemPatchListener
implements Listener {
    public static final EnumSet<PatchScope> VALID_SCOPES = EnumSet.of(PatchScope.SlimefunItem, PatchScope.ItemMarkItem, PatchScope.BookMarkItem, PatchScope.SearchItem, PatchScope.ItemRecipeIngredient);
    public static final DecimalFormat EMCFormat = new DecimalFormat("#.###");

    @EventHandler(priority=EventPriority.HIGHEST)
    public void patchItem(@NotNull PatchEvent event) {
        PatchScope scope = event.getPatchScope();
        if (this.notValid(scope)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.disabledOption(player)) {
            return;
        }
        this.patchItem(event.getItemStack(), scope);
    }

    public boolean notValid(@NotNull PatchScope patchScope) {
        return !VALID_SCOPES.contains((Object)patchScope);
    }

    public boolean disabledOption(@NotNull Player player) {
        return !EMCValueDisplayOption.isEnabled(player);
    }

    public void patchItem(@Nullable ItemStack itemStack, @NotNull PatchScope scope) {
        if (itemStack == null) {
            return;
        }
        if (scope == PatchScope.ItemRecipeIngredient && StackUtils.itemsMatch(itemStack, new ItemStack(itemStack.getType()))) {
            return;
        }
        double emc = EMCTechIntegrationMain.getEMC(itemStack);
        if (emc <= 0.0) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(ChatColors.color((String)("&7EMC: &6" + EMCFormat.format(emc))));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }
}

