/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches.slimefun;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FireworksOption
implements SlimefunGuideOption<Boolean> {
    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return new NamespacedKey((Plugin)Slimefun.instance(), "research_fireworks");
    }

    public Optional<ItemStack> getDisplayItem(Player p, ItemStack guide) {
        SlimefunRegistry registry = Slimefun.getRegistry();
        if (registry.isResearchingEnabled() && registry.isResearchFireworkEnabled()) {
            boolean enabled = this.getSelectedOption(p, guide).orElse(true);
            CustomItemStack item = new CustomItemStack(Material.FIREWORK_ROCKET, "&bFireworks: &" + (enabled ? "aYes" : "4No"), new String[]{"", "&7You can now toggle whether you", "&7will be presented with a big firework", "&7upon researching an item.", "", "&7\u21e8 &eClick to " + (enabled ? "disable" : "enable") + " your fireworks"});
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public void onClick(Player p, ItemStack guide) {
        this.setSelectedOption(p, guide, this.getSelectedOption(p, guide).orElse(true) == false);
        JEGGuideSettings.openSettings(p, guide);
    }

    public Optional<Boolean> getSelectedOption(Player p, ItemStack guide) {
        NamespacedKey key = this.getKey();
        boolean value = !PersistentDataAPI.hasByte((PersistentDataHolder)p, (NamespacedKey)key) || PersistentDataAPI.getByte((PersistentDataHolder)p, (NamespacedKey)key) == 1;
        return Optional.of(value);
    }

    public void setSelectedOption(Player p, ItemStack guide, Boolean value) {
        PersistentDataAPI.setByte((PersistentDataHolder)p, (NamespacedKey)this.getKey(), (byte)((byte)(value != false ? 1 : 0)));
    }
}

