/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.compatibility;

import com.balugaq.jeg.utils.compatibility.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Experimental
public class Converter {
    public static final ItemStack AIR = new ItemStack(Material.AIR);
    @Nullable
    public static final ItemGetter methodHandleSlimefunItemStack_item = Converter.createItemGetter();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static ItemStack getItem(@NotNull SlimefunItemStack slimefunItemStack) {
        return Converter.asBukkit(slimefunItemStack);
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack) {
        return new CustomItemStack(itemStack).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material) {
        return new CustomItemStack(material).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull Consumer<ItemMeta> itemMetaConsumer) {
        return new CustomItemStack(itemStack, itemMetaConsumer).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @NotNull Consumer<ItemMeta> consumer) {
        return new CustomItemStack(material, consumer).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @Nullable String name, @NotNull List<String> lore) {
        return new CustomItemStack(itemStack, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @Nullable String name, String ... lore) {
        return new CustomItemStack(itemStack, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, Color color, @Nullable String name, String ... lore) {
        return new CustomItemStack(itemStack, color, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @Nullable String name, String ... lore) {
        return new CustomItemStack(material, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, String name, @NotNull List<String> lore) {
        return new CustomItemStack(material, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull List<String> list) {
        return new CustomItemStack(itemStack, list).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @NotNull List<String> list) {
        return new CustomItemStack(material, list).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @Range(from=1L, to=0x7FFFFFFFL) int amount) {
        return new CustomItemStack(itemStack, amount).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull Material material) {
        return new CustomItemStack(itemStack, material).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @NotNull String name, @NotNull Consumer<ItemMeta> consumer) {
        return new CustomItemStack(new CustomItemStack(material, name, new String[0]).asBukkit(), consumer).asBukkit();
    }

    @Nullable
    private static ItemGetter createItemGetter() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mt = MethodType.methodType(ItemStack.class);
            MethodHandle handle = lookup.findVirtual(SlimefunItemStack.class, "item", mt);
            return LambdaMetafactory.metafactory(lookup, "getItem", MethodType.methodType(ItemGetter.class), handle.type().generic(), handle, handle.type()).getTarget().invokeExact();
        }
        catch (Exception t) {
            return null;
        }
    }

    @NotNull
    public static ItemStack asBukkit(@Nullable SlimefunItemStack item) {
        ItemStack itemStack;
        if (item == null) {
            return AIR.clone();
        }
        if (ItemStack.class.isInstance(item)) {
            itemStack = (ItemStack)ItemStack.class.cast(item);
        } else if (methodHandleSlimefunItemStack_item != null) {
            try {
                itemStack = (ItemStack)ItemStack.class.cast(methodHandleSlimefunItemStack_item.getItem(item));
            }
            catch (Throwable e) {
                return AIR.clone();
            }
        } else {
            return AIR.clone();
        }
        ItemStack bukkitItem = new ItemStack(itemStack.getType());
        bukkitItem.setAmount(item.getAmount());
        if (item.hasItemMeta()) {
            bukkitItem.setItemMeta(item.getItemMeta());
        }
        return bukkitItem;
    }

    public static class Builder {
        public final List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        public boolean ifValue = true;
        public int index = 0;

        @NotNull
        public Builder if_(boolean expression) {
            this.ifValue = expression;
            return this;
        }

        @NotNull
        public Builder thenTryFirst() {
            this.index = 0;
            return this;
        }

        @NotNull
        public Builder thenTrySecond() {
            this.index = 1;
            return this;
        }

        @NotNull
        public Builder thenTry(int index) {
            this.index = index;
            return this;
        }

        @NotNull
        public Builder add(@NotNull SlimefunItemStack slimefunItemStack) {
            this.itemStacks.add(Converter.getItem(slimefunItemStack));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack) {
            this.itemStacks.add(Converter.getItem(itemStack));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material) {
            this.itemStacks.add(Converter.getItem(material));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, @NotNull Consumer<ItemMeta> itemMetaConsumer) {
            this.itemStacks.add(Converter.getItem(itemStack, itemMetaConsumer));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material, @NotNull Consumer<ItemMeta> itemMetaConsumer) {
            this.itemStacks.add(Converter.getItem(material, itemMetaConsumer));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, @Nullable String name, String ... lore) {
            this.itemStacks.add(Converter.getItem(itemStack, name, lore));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, Color color, @Nullable String name, String ... lore) {
            this.itemStacks.add(Converter.getItem(itemStack, color, name, lore));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material, String name, String ... lore) {
            this.itemStacks.add(Converter.getItem(material, name, lore));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material, String name, @NotNull List<String> lore) {
            this.itemStacks.add(Converter.getItem(material, name, lore));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, @NotNull List<String> list) {
            this.itemStacks.add(Converter.getItem(itemStack, list));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material, @NotNull List<String> list) {
            this.itemStacks.add(Converter.getItem(material, list));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, @Range(from=1L, to=0x7FFFFFFFL) int amount) {
            this.itemStacks.add(Converter.getItem(itemStack, amount));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ItemStack itemStack, @NotNull Material material) {
            this.itemStacks.add(Converter.getItem(itemStack, material));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material, @NotNull String name, @NotNull Consumer<ItemMeta> consumer) {
            this.itemStacks.add(Converter.getItem(material, name, consumer));
            return this;
        }

        public ItemStack thenFirst() {
            return this.ifValue ? this.itemStacks.get(this.index) : AIR.clone();
        }

        public ItemStack thenSecond() {
            return this.ifValue ? this.itemStacks.get(this.index) : AIR.clone();
        }

        public ItemStack then(int index) {
            return this.ifValue ? this.itemStacks.get(index) : AIR.clone();
        }

        public ItemStack orElse() {
            return this.ifValue ? this.itemStacks.get(this.index) : AIR.clone();
        }

        public ItemStack orElse(int index) {
            return this.ifValue ? this.itemStacks.get(this.index) : this.itemStacks.get(index);
        }

        public ItemStack orElse(ItemStack itemStack) {
            return this.ifValue ? this.itemStacks.get(this.index) : itemStack;
        }

        public ItemStack orElseGet(@NotNull Supplier<ItemStack> supplier) {
            return this.ifValue ? this.itemStacks.get(this.index) : supplier.get();
        }

        @NotNull
        public ItemStack findFirst() {
            return this.itemStacks.stream().filter(itemStack -> itemStack != null && itemStack.getType() != Material.AIR).findFirst().orElse(AIR.clone());
        }
    }

    @FunctionalInterface
    public static interface ItemGetter {
        public ItemStack getItem(SlimefunItemStack var1);
    }
}

