/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.networksexpansion;

import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.recipe_complete.source.base.VanillaSource;
import com.balugaq.jeg.core.integrations.networksexpansion.NetworksExpansionIntegrationMain;
import com.balugaq.jeg.core.listeners.RecipeCompletableListener;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.InventoryUtil;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworksExpansionRecipeCompleteVanillaSource
implements VanillaSource {
    @Override
    public boolean handleable(@NotNull Block block, @NotNull Inventory inventory, @NotNull Player player, @NotNull ClickAction clickAction, int @NotNull [] ingredientSlots, boolean unordered) {
        return NetworksExpansionIntegrationMain.findNearbyNetworkRoot(block.getLocation()) != null;
    }

    @Override
    public boolean openGuide(@NotNull Block block, @NotNull Inventory inventory, @NotNull Player player, @NotNull ClickAction clickAction, int @NotNull [] ingredientSlots, boolean unordered, @Nullable Runnable callback) {
        GuideEvents.ItemButtonClickEvent lastEvent = RecipeCompletableListener.getLastEvent(player.getUniqueId());
        if (clickAction.isRightClicked() && lastEvent != null) {
            int times = 1;
            if (clickAction.isShiftClicked()) {
                times = 64;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(block, inventory, lastEvent, ingredientSlots, unordered);
            }
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        GuideUtil.openMainMenuAsync(player, SlimefunGuideMode.SURVIVAL_MODE, 1);
        RecipeCompletableListener.addCallback(player.getUniqueId(), (event, profile) -> {
            int times = 1;
            if (event.getClickAction().isRightClicked()) {
                times = 64;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(block, inventory, (GuideEvents.ItemButtonClickEvent)((Object)event), ingredientSlots, unordered);
            }
            player.updateInventory();
            player.openInventory(inventory);
            if (callback != null) {
                callback.run();
            }
        });
        RecipeCompletableListener.tagGuideOpen(player);
        return true;
    }

    @Override
    public boolean completeRecipeWithGuide(@NotNull Block block, @NotNull Inventory inventory,  @NotNull GuideEvents.ItemButtonClickEvent event, int @NotNull [] ingredientSlots, boolean unordered) {
        NetworkRoot root = NetworksExpansionIntegrationMain.findNearbyNetworkRoot(block.getLocation());
        if (root == null) {
            return false;
        }
        Player player = event.getPlayer();
        ItemStack clickedItem = event.getClickedItem();
        if (clickedItem == null) {
            return false;
        }
        List<RecipeChoice> choices = this.getRecipe(clickedItem);
        if (choices == null) {
            return false;
        }
        for (int i = 0; i < 9 && i < choices.size() && i < ingredientSlots.length; ++i) {
            ItemStack existing;
            RecipeChoice choice = choices.get(i);
            if (choice == null || !unordered && (existing = inventory.getItem(ingredientSlots[i])) != null && existing.getType() != Material.AIR && (existing.getAmount() >= existing.getMaxStackSize() || !choice.test(existing))) continue;
            if (choice instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)choice;
                List<ItemStack> itemStacks = materialChoice.getChoices().stream().map(ItemStack::new).toList();
                for (ItemStack itemStack : itemStacks) {
                    ItemStack received = this.getItemStack(root, player, itemStack);
                    if (received == null || received.getType() == Material.AIR) continue;
                    if (unordered) {
                        InventoryUtil.pushItem(inventory, received, ingredientSlots);
                        continue;
                    }
                    InventoryUtil.pushItem(inventory, received, ingredientSlots[i]);
                }
                continue;
            }
            if (!(choice instanceof RecipeChoice.ExactChoice)) continue;
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)choice;
            for (ItemStack itemStack : exactChoice.getChoices()) {
                ItemStack received = this.getItemStack(root, player, itemStack);
                if (received == null || received.getType() == Material.AIR) continue;
                if (unordered) {
                    InventoryUtil.pushItem(inventory, received, ingredientSlots);
                    continue;
                }
                InventoryUtil.pushItem(inventory, received, ingredientSlots[i]);
            }
        }
        event.setCancelled(true);
        return true;
    }

    @Nullable
    private ItemStack getItemStack(@NotNull NetworkRoot root, @NotNull Player player, @NotNull ItemStack itemStack) {
        ItemStack i1 = this.getItemStackFromPlayerInventory(player, itemStack);
        if (i1 != null) {
            return i1;
        }
        return root.getItemStack0(player.getLocation(), new ItemRequest(itemStack, 1));
    }

    @Override
    public JavaPlugin plugin() {
        return NetworksExpansionIntegrationMain.getPlugin();
    }
}

