/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.clickhandler;

import com.balugaq.jeg.api.clickhandler.JEGClickHandler;
import com.balugaq.jeg.api.clickhandler.Processor;
import com.balugaq.jeg.api.objects.collection.cooldown.FrequencyWatcher;
import com.balugaq.jeg.utils.ClipboardUtil;
import com.balugaq.jeg.utils.clickhandler.Applier;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import net.guizhanss.guizhanlib.minecraft.helper.inventory.ItemStackHelper;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NamePrinter
implements Applier {
    public static final MessageFormat SHARED_ITEM_MESSAGE = new MessageFormat(ChatColors.color((String)"&a{0} &e\u5206\u4eab\u4e86\u7269\u54c1 &7[{1}&r&7]&e <\u70b9\u51fb\u641c\u7d22>"));
    public static final String CLICK_TO_SEARCH = ChatColors.color((String)"&e\u70b9\u51fb\u641c\u7d22\u7269\u54c1");
    private static final NamePrinter instance = new NamePrinter();
    private static final FrequencyWatcher<UUID> watcher = new FrequencyWatcher(1, TimeUnit.MINUTES, 10L, 5000L);

    private NamePrinter() {
    }

    public static void applyWith(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, int slot) {
        instance.apply(guide, menu, slot);
    }

    @ParametersAreNonnullByDefault
    private static void shareSlimefunItem(Player player, String itemName) {
        String playerName = player.getName();
        String sharedMessage = SHARED_ITEM_MESSAGE.format(new Object[]{playerName, ChatColors.color((String)itemName)});
        TextComponent msg = new TextComponent(sharedMessage);
        msg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(CLICK_TO_SEARCH)}));
        String s = ChatColor.stripColor((String)itemName);
        msg.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sf search " + s));
        Bukkit.getOnlinePlayers().forEach(p -> {
            if (p.hasPermission("slimefun.command.search")) {
                ClipboardUtil.send(p, msg);
            } else {
                ClipboardUtil.send(p, ClipboardUtil.makeComponent(sharedMessage, CLICK_TO_SEARCH, itemName));
            }
        });
    }

    public static boolean checkCooldown(@NotNull Player player) {
        FrequencyWatcher.Result result = watcher.checkCooldown(player.getUniqueId());
        if (result == FrequencyWatcher.Result.TOO_FREQUENT) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u7684\u4f7f\u7528\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u4f7f\u7528!");
            return false;
        }
        if (result == FrequencyWatcher.Result.CANCEL) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u8fd9\u4e2a\u529f\u80fd\u6b63\u5728\u51b7\u5374\u4e2d...");
            return false;
        }
        return true;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(SlimefunGuideImplementation guide, ChestMenu menu, int slot) {
        menu.addMenuClickHandler(slot, (ChestMenu.MenuClickHandler)JEGClickHandler.of(guide, menu, slot).addProcessor(NamePrinterProcessor.getInstance()));
    }

    public static class NamePrinterProcessor
    extends Processor {
        private static final NamePrinterProcessor instance = new NamePrinterProcessor();

        public NamePrinterProcessor() {
            super(Processor.Strategy.HEAD);
        }

        @Override
        public boolean process(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, @NotNull InventoryClickEvent event, @NotNull Player player, @Range(from=0L, to=53L) int clickedSlot, @Nullable ItemStack clickedItemStack, @NotNull ClickAction clickAction, @Nullable Boolean processedResult) {
            if (clickedItemStack != null && clickedItemStack.getType() != Material.AIR && (event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP)) {
                if (!NamePrinter.checkCooldown(player)) {
                    return false;
                }
                String name = ItemStackHelper.getDisplayName((ItemStack)clickedItemStack);
                NamePrinter.shareSlimefunItem(player, name);
                return false;
            }
            return true;
        }

        @Generated
        public static NamePrinterProcessor getInstance() {
            return instance;
        }
    }
}

