/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInSurvivalMode
public class HiddenItemsGroup
extends FlexItemGroup {
    private static final List<SlimefunItem> ALL_SLIMEFUN_ITEMS = Slimefun.getRegistry().getAllSlimefunItems();
    @Deprecated
    private static final int BACK_SLOT = 1;
    @Deprecated
    private static final int SEARCH_SLOT = 7;
    @Deprecated
    private static final int PREVIOUS_SLOT = 46;
    @Deprecated
    private static final int NEXT_SLOT = 52;
    @Deprecated
    private static final int[] BORDER = new int[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
    @Deprecated
    private static final int[] MAIN_CONTENT = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final int page;
    private final List<SlimefunItem> slimefunItemList;
    private Map<Integer, HiddenItemsGroup> pageMap = new LinkedHashMap<Integer, HiddenItemsGroup>();

    @ParametersAreNonnullByDefault
    public HiddenItemsGroup(NamespacedKey key, ItemStack icon) {
        super(key, icon);
        this.page = 1;
        ArrayList<SlimefunItem> slimefunItemList = new ArrayList<SlimefunItem>();
        for (SlimefunItem item : ALL_SLIMEFUN_ITEMS) {
            if (!item.isDisabled() && item.isHidden()) {
                slimefunItemList.add(item);
            }
            try {
                if (item.getItemGroup().isAccessible(null)) continue;
                slimefunItemList.add(item);
            }
            catch (Throwable throwable) {}
        }
        this.slimefunItemList = slimefunItemList;
        this.pageMap.put(1, this);
    }

    protected HiddenItemsGroup(@NotNull HiddenItemsGroup hiddenItemsGroup, int page) {
        super(hiddenItemsGroup.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.slimefunItemList = hiddenItemsGroup.slimefunItemList;
        this.pageMap.put(page, this);
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return true;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu("Hidden Items");
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        for (Integer n : Formats.sub.getChars('b')) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(n.intValue(), (pl, s, is, action) -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.CHEAT_MODE));
                }
                return false;
            });
        }
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.CHEAT_MODE);
        for (Integer ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss.intValue(), (pl, slot, item, action) -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> implementation.openSearch(playerProfile, msg, implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            });
        }
        for (Integer ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss.intValue(), (p, slot, item, action) -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                HiddenItemsGroup hiddenItemsGroup = this.getByPage(Math.max(this.page - 1, 1));
                hiddenItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            });
        }
        for (Integer ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss.intValue(), (p, slot, item, action) -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                HiddenItemsGroup hiddenItemsGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1));
                hiddenItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            });
        }
        for (Integer ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss.intValue(), ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> list = Formats.sub.getChars('i');
        for (int i = 0; i < list.size(); ++i) {
            ChestMenu.MenuClickHandler handler;
            ItemStack itemstack;
            int index = i + this.page * list.size() - list.size();
            if (index >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(index);
            Research research = slimefunItem.getResearch();
            if (implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE && research != null && !playerProfile.hasUnlocked(research)) {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)slimefunItem.getItem()), "&7" + slimefunItem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(player, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())));
                handler = (pl, slot, item, action) -> {
                    research.unlockFromGuide(implementation, pl, playerProfile, slimefunItem, slimefunItem.getItemGroup(), this.page);
                    return false;
                };
            } else {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(slimefunItem.getItem(), meta -> {
                    ItemGroup itemGroup = slimefunItem.getItemGroup();
                    List<CallSite> additionLore = List.of("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + LocalHelper.getAddonName(itemGroup, slimefunItem.getId()) + String.valueOf(ChatColor.WHITE) + " - " + LocalHelper.getDisplayName(itemGroup, player));
                    if (meta.hasLore() && meta.getLore() != null) {
                        List lore = meta.getLore();
                        lore.addAll(additionLore);
                        meta.setLore(lore);
                    } else {
                        meta.setLore(additionLore);
                    }
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }));
                handler = (pl, slot, itm, action) -> {
                    try {
                        if (implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                            pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                        } else {
                            implementation.displayItem(playerProfile, slimefunItem, true);
                        }
                    }
                    catch (Exception | LinkageError x) {
                        this.printErrorMessage(pl, slimefunItem, x);
                    }
                    return false;
                };
            }
            chestMenu.addItem(list.get(i).intValue(), ItemStackUtil.getCleanItem(itemstack), handler);
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, implementation);
        if (implementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)implementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private HiddenItemsGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        HiddenItemsGroup hiddenItemsGroup = this.pageMap.get(1);
        synchronized (hiddenItemsGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            HiddenItemsGroup hiddenItemsGroup2 = new HiddenItemsGroup(this, page);
            hiddenItemsGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, hiddenItemsGroup2);
            return hiddenItemsGroup2;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(@NotNull Player p, @NotNull SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    public boolean isCrossAddonItemGroup() {
        return true;
    }

    public int getTier() {
        return Integer.MAX_VALUE;
    }
}

