/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.core.listeners.SearchGroupInitListener;
import com.balugaq.jeg.core.listeners.SpecialMenuFixListener;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListenerManager
extends AbstractManager {
    @NotNull
    final List<Listener> listeners = new ArrayList<Listener>();
    private final JavaPlugin plugin;

    public ListenerManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.listeners.add(new GuideListener());
        this.listeners.add(new SearchGroupInitListener());
        this.listeners.add(new SpecialMenuFixListener());
        this.listeners.add(new RTSListener());
    }

    private void registerListeners() {
        for (Listener listener : this.listeners) {
            Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
    }

    private void unregisterListeners() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    @Override
    public void load() {
        this.registerListeners();
    }

    @Override
    public void unload() {
        this.unregisterListeners();
    }

    @NotNull
    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

