/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.formatter;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public abstract class Format {
    public final Map<Integer, Character> mapping = new HashMap<Integer, Character>();
    @Deprecated
    public final Map<Character, ItemStackFormat> formats = new HashMap<Character, ItemStackFormat>();
    public final Map<Character, List<Integer>> cached = new HashMap<Character, List<Integer>>();
    public int size = 54;

    public Format() {
        this.formats.put(Character.valueOf('B'), new Background());
        this.formats.put(Character.valueOf('R'), new RealTimeSearch());
        this.formats.put(Character.valueOf('C'), new BookMark());
        this.formats.put(Character.valueOf('c'), new ItemMark());
        this.formats.put(Character.valueOf('b'), new Back());
        this.formats.put(Character.valueOf('T'), new Settings());
        this.formats.put(Character.valueOf('S'), new Search());
        this.formats.put(Character.valueOf('P'), new PagePrevious());
        this.formats.put(Character.valueOf('N'), new PageNext());
        this.loadMapping();
    }

    public abstract void loadMapping();

    @Deprecated
    @OverridingMethodsMustInvokeSuper
    public void decorate(ChestMenu menu, Player player) {
        for (Map.Entry<Integer, Character> entry : this.mapping.entrySet()) {
            ItemStackFormat format = this.formats.get(entry.getValue());
            if (format instanceof ItemStackSupplier) {
                ItemStackSupplier supplier = (ItemStackSupplier)format;
                menu.addItem(entry.getKey().intValue(), supplier.get());
                continue;
            }
            if (format instanceof Back) {
                Back function = (Back)format;
                menu.addItem(entry.getKey().intValue(), function.apply(player));
                continue;
            }
            if (format instanceof Settings) {
                Settings function = (Settings)format;
                menu.addItem(entry.getKey().intValue(), function.apply(player));
                continue;
            }
            if (!(format instanceof Search)) continue;
            Search function = (Search)format;
            menu.addItem(entry.getKey().intValue(), function.apply(player));
        }
    }

    @Deprecated
    @OverridingMethodsMustInvokeSuper
    public void decoratePage(ChestMenu menu, Player player, int page, int maxPage) {
        for (Map.Entry<Integer, Character> entry : this.mapping.entrySet()) {
            ItemStackFormat format = this.formats.get(entry.getValue());
            if (format instanceof PagePrevious) {
                PagePrevious function = (PagePrevious)format;
                menu.addItem(entry.getKey().intValue(), function.apply(player, page, maxPage));
                continue;
            }
            if (!(format instanceof PageNext)) continue;
            PageNext function = (PageNext)format;
            menu.addItem(entry.getKey().intValue(), function.apply(player, page, maxPage));
        }
    }

    @ApiStatus.Obsolete
    public void loadMapping(List<String> format) {
        int index = -1;
        for (String string : format) {
            for (char c : string.toCharArray()) {
                ++index;
                if (c == ' ') continue;
                this.mapping.put(index, Character.valueOf(c));
            }
        }
    }

    @ApiStatus.Obsolete
    public List<Integer> getChars(String s) {
        return this.getChars(s.toCharArray()[0]);
    }

    @ApiStatus.Obsolete
    public List<Integer> getChars(char c) {
        if (this.cached.containsKey(Character.valueOf(c))) {
            return this.cached.get(Character.valueOf(c));
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, Character> entry : this.mapping.entrySet()) {
            if (entry.getValue().charValue() != c) continue;
            list.add(entry.getKey());
        }
        this.cached.put(Character.valueOf(c), list);
        return list;
    }

    @Generated
    public Map<Integer, Character> getMapping() {
        return this.mapping;
    }

    @Deprecated
    @Generated
    public Map<Character, ItemStackFormat> getFormats() {
        return this.formats;
    }

    @Generated
    public Map<Character, List<Integer>> getCached() {
        return this.cached;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Deprecated
    public static class Background
    implements ItemStackSupplier {
        @Override
        public ItemStack get() {
            return ChestMenuUtils.getBackground();
        }
    }

    @Deprecated
    public static class RealTimeSearch
    implements ItemStackSupplier {
        @Override
        public ItemStack get() {
            return JustEnoughGuide.getConfigManager().isRTSSearch() ? Lang.RTS_ITEM : ChestMenuUtils.getBackground();
        }
    }

    @Deprecated
    public static class BookMark
    implements ItemStackSupplier {
        @Override
        public ItemStack get() {
            return JustEnoughGuide.getConfigManager().isBookmark() ? GuideUtil.getBookMarkMenuButton() : ChestMenuUtils.getBackground();
        }
    }

    @Deprecated
    public static class ItemMark
    implements ItemStackSupplier {
        @Override
        public ItemStack get() {
            return JustEnoughGuide.getConfigManager().isBookmark() ? GuideUtil.getItemMarkMenuButton() : ChestMenuUtils.getBackground();
        }
    }

    @Deprecated
    public static class Back
    implements ItemStackFunction<Player> {
        @Override
        public ItemStack apply(Player player) {
            return SlimefunOfficialSupporter.getBackButton(player);
        }
    }

    @Deprecated
    public static class Settings
    implements ItemStackFunction<Player> {
        @Override
        public ItemStack apply(Player p) {
            return ChestMenuUtils.getMenuButton((Player)p);
        }
    }

    @Deprecated
    public static class Search
    implements ItemStackFunction<Player> {
        @Override
        public ItemStack apply(Player p) {
            return ChestMenuUtils.getSearchButton((Player)p);
        }
    }

    @Deprecated
    public static class PagePrevious
    implements ItemStackCiFunction<Player, Integer, Integer> {
        @Override
        public ItemStack apply(Player player, Integer page, Integer maxPage) {
            return ChestMenuUtils.getPreviousButton((Player)player, (int)page, (int)maxPage);
        }
    }

    @Deprecated
    public static class PageNext
    implements ItemStackCiFunction<Player, Integer, Integer> {
        @Override
        public ItemStack apply(Player player, Integer page, Integer maxPage) {
            return ChestMenuUtils.getNextButton((Player)player, (int)page, (int)maxPage);
        }
    }

    @Deprecated
    public static interface ItemStackFormat {
    }

    @Deprecated
    public static interface ItemStackSupplier
    extends Supplier<ItemStack>,
    ItemStackFormat {
        @Override
        public ItemStack get();
    }

    @Deprecated
    public static class BigRecipe
    implements ItemStackSupplier {
        @Override
        public ItemStack get() {
            return Lang.SPECIAL_MENU_ITEM;
        }
    }

    @Deprecated
    public static interface CiFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }

    @Deprecated
    public static interface ItemStackFunction<A>
    extends Function<A, ItemStack>,
    ItemStackFormat {
        @Override
        public ItemStack apply(A var1);
    }

    @Deprecated
    public static interface ItemStackBiFunction<A, B>
    extends BiFunction<A, B, ItemStack>,
    ItemStackFormat {
        @Override
        public ItemStack apply(A var1, B var2);
    }

    @Deprecated
    public static interface ItemStackCiFunction<A, B, C>
    extends CiFunction<A, B, C, ItemStack>,
    ItemStackFormat {
    }
}

