/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.api.groups.RTSSearchGroup;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.BookmarkRelocation;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.objects.events.RTSEvents;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.formatter.Format;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GuideUtil {
    private static final ItemStack BOOK_MARK_MENU_BUTTON = Lang.getIcon("book-mark-button", Material.NETHER_STAR);
    private static final ItemStack ITEM_MARK_MENU_BUTTON = Lang.getIcon("item-mark-button", Material.WRITABLE_BOOK);

    @ParametersAreNonnullByDefault
    public static void openMainMenuAsync(Player player, SlimefunGuideMode mode, int selectedPage) {
        if (!PlayerProfile.get((OfflinePlayer)player, profile -> Slimefun.runSync(() -> GuideUtil.openMainMenu(player, profile, mode, selectedPage)))) {
            Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.opening-guide");
        }
    }

    @ParametersAreNonnullByDefault
    public static void openMainMenu(Player player, PlayerProfile profile, SlimefunGuideMode mode, int selectedPage) {
        GuideUtil.getGuide(player, mode).openMainMenu(profile, selectedPage);
    }

    @NotNull
    public static SlimefunGuideImplementation getGuide(@NotNull Player player, SlimefunGuideMode mode) {
        if (mode == SlimefunGuideMode.SURVIVAL_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
        }
        if ((player.isOp() || player.hasPermission("slimefun.cheat.items")) && mode == SlimefunGuideMode.CHEAT_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.CHEAT_MODE);
        }
        return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
    }

    public static void removeLastEntry(@NotNull GuideHistory guideHistory) {
        try {
            Method getLastEntry = guideHistory.getClass().getDeclaredMethod("getLastEntry", Boolean.TYPE);
            getLastEntry.setAccessible(true);
            getLastEntry.invoke((Object)guideHistory, true);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Debug.trace(e);
        }
    }

    @NotNull
    public static ItemStack getBookMarkMenuButton() {
        return BOOK_MARK_MENU_BUTTON;
    }

    @NotNull
    public static ItemStack getItemMarkMenuButton() {
        return ITEM_MARK_MENU_BUTTON;
    }

    public static boolean isTaggedGroupType(@NotNull ItemGroup itemGroup) {
        Class<?> clazz = itemGroup.getClass();
        return !(itemGroup instanceof FlexItemGroup) && (clazz == ItemGroup.class || clazz == SubItemGroup.class || clazz == LockedItemGroup.class || clazz == SeasonalItemGroup.class || itemGroup instanceof BookmarkRelocation || clazz.getName().equalsIgnoreCase("me.voper.slimeframe.implementation.groups.ChildGroup") || clazz.getName().endsWith("DummyItemGroup") || clazz.getName().endsWith("SubGroup"));
    }

    public static void addRTSButton(ChestMenu menu, Player p, PlayerProfile profile, Format format, SlimefunGuideMode mode, SlimefunGuideImplementation implementation) {
        if (JustEnoughGuide.getConfigManager().isRTSSearch()) {
            for (Integer ss : format.getChars('R')) {
                menu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(Lang.RTS_ITEM), (pl, slot, itemstack, action) -> {
                    try {
                        RTSSearchGroup.newRTSInventoryFor(pl, mode, (s, stateSnapshot) -> {
                            SearchGroup rts;
                            if (s == 0) {
                                GuideHistory history = profile.getGuideHistory();
                                if (action.isShiftClicked()) {
                                    implementation.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                                } else {
                                    history.goBack(implementation);
                                }
                                return;
                            }
                            if (s == 1) {
                                SearchGroup rts2 = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl);
                                if (rts2 != null) {
                                    int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                                    int newPage = Math.max(1, oldPage - 1);
                                    RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, mode);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                                        synchronized (map) {
                                            RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                                        }
                                    }
                                }
                            } else if (s == 2 && (rts = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl)) != null) {
                                int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                                int newPage = Math.min((rts.slimefunItemList.size() - 1) / RTSListener.FILL_ORDER.length + 1, oldPage + 1);
                                RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, mode);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                                    synchronized (map) {
                                        RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                                    }
                                }
                            }
                        }, new int[]{0, 1, 2}, null);
                    }
                    catch (Throwable ignored) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "Incompatibile version! Unable to open RTS!");
                    }
                    return false;
                });
            }
        } else {
            for (Integer ss : format.getChars('R')) {
                menu.addItem(ss.intValue(), ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    public static void addBookMarkButton(ChestMenu menu, Player p, PlayerProfile profile, Format format, JEGSlimefunGuideImplementation implementation, ItemGroup itemGroup) {
        if (JustEnoughGuide.getConfigManager().isBookmark()) {
            BookmarkRelocation bookmarkRelocation;
            if (itemGroup instanceof BookmarkRelocation) {
                BookmarkRelocation bookmarkRelocation2 = (BookmarkRelocation)itemGroup;
                bookmarkRelocation = bookmarkRelocation2;
            } else {
                bookmarkRelocation = null;
            }
            BookmarkRelocation b = bookmarkRelocation;
            for (Integer s : b != null ? b.getBookMark(implementation, p) : format.getChars('C')) {
                menu.addItem(s.intValue(), ItemStackUtil.getCleanItem(GuideUtil.getBookMarkMenuButton()), (pl, slot, itemstack, action) -> {
                    implementation.openBookMarkGroup(pl, profile);
                    return false;
                });
            }
        } else {
            for (Integer s : format.getChars('C')) {
                menu.addItem(s.intValue(), ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    public static void addItemMarkButton(ChestMenu menu, Player p, PlayerProfile profile, Format format, JEGSlimefunGuideImplementation implementation, ItemGroup itemGroup) {
        if (itemGroup != null && JustEnoughGuide.getConfigManager().isBookmark() && GuideUtil.isTaggedGroupType(itemGroup)) {
            BookmarkRelocation bookmarkRelocation;
            if (itemGroup instanceof BookmarkRelocation) {
                BookmarkRelocation relocation = (BookmarkRelocation)itemGroup;
                bookmarkRelocation = relocation;
            } else {
                bookmarkRelocation = null;
            }
            BookmarkRelocation b = bookmarkRelocation;
            for (Integer ss : b != null ? b.getItemMark(implementation, p) : format.getChars('c')) {
                menu.addItem(ss.intValue(), ItemStackUtil.getCleanItem(GuideUtil.getItemMarkMenuButton()), (pl, slot, itemstack, action) -> {
                    implementation.openItemMarkGroup(itemGroup, pl, profile);
                    return false;
                });
            }
        } else {
            for (Integer ss : format.getChars('c')) {
                menu.addItem(ss.intValue(), ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    @Generated
    private GuideUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

