/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.clickhandler;

import com.balugaq.jeg.api.objects.ExtendedClickHandler;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.option.BeginnersGuideOption;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.guizhanlib.minecraft.helper.inventory.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BeginnerUtils {
    public static void applyBeginnersGuide(SlimefunGuideImplementation guide, ChestMenu menu, int slot) {
        if (!JustEnoughGuide.getConfigManager().isBeginnerOption()) {
            return;
        }
        ChestMenu.MenuClickHandler origin = menu.getMenuClickHandler(slot);
        if (origin instanceof BeginnerClickHandler) {
            return;
        }
        menu.addMenuClickHandler(slot, (player, clickedSlot, clickedItem, action) -> {
            if (BeginnerUtils.isNew(player) && action.isShiftClicked() && action.isRightClicked() && clickedItem != null) {
                PlayerProfile.get((OfflinePlayer)player, profile -> guide.openSearch(profile, ChatColor.stripColor((String)ItemStackHelper.getDisplayName((ItemStack)clickedItem)), true));
                return false;
            }
            if (origin != null) {
                return origin.onClick(player, clickedSlot, clickedItem, action);
            }
            return false;
        });
    }

    public static boolean isNew(Player player) {
        return BeginnersGuideOption.isEnabled(player);
    }

    public static interface BeginnerClickHandler
    extends ExtendedClickHandler {
    }
}

