/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Lang;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Debug {
    private static final String debugPrefix = Lang.getDebug("debug-prefix");
    private static JavaPlugin plugin;

    public static void debug(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.debug(sb.toString());
    }

    public static void debug(@NotNull Throwable e) {
        Debug.debug(e.getMessage());
        Debug.trace(e);
    }

    public static void debug(@NotNull Object object) {
        Debug.debug(object.toString());
    }

    public static void debug(String ... messages) {
        for (String message : messages) {
            Debug.debug(message);
        }
    }

    public static void debug(String message) {
        if (JustEnoughGuide.getConfigManager().isDebug()) {
            Debug.log(debugPrefix + message);
        }
    }

    public static void sendMessage(@NotNull Player player, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.sendMessage(player, sb.toString());
    }

    public static void sendMessage(@NotNull Player player, @Nullable Object object) {
        if (object == null) {
            Debug.sendMessage(player, "null");
            return;
        }
        Debug.sendMessage(player, object.toString());
    }

    public static void sendMessages(@NotNull Player player, String ... messages) {
        for (String message : messages) {
            Debug.sendMessage(player, message);
        }
    }

    public static void sendMessage(@NotNull Player player, String message) {
        Debug.init();
        player.sendMessage("[" + plugin.getLogger().getName() + "]" + message);
    }

    public static void stackTraceManually() {
        try {
            throw new Error();
        }
        catch (Throwable e) {
            Debug.trace(e);
            return;
        }
    }

    public static void log(Object ... object) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : object) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.log(sb.toString());
    }

    public static void log(@NotNull Object object) {
        Debug.log(object.toString());
    }

    public static void log(String ... messages) {
        for (String message : messages) {
            Debug.log(message);
        }
    }

    public static void log(@NotNull String message) {
        Debug.init();
        plugin.getServer().getConsoleSender().sendMessage("[" + JustEnoughGuide.getInstance().getName() + "] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static void log(@NotNull Throwable e) {
        Debug.trace(e);
    }

    public static void log() {
        Debug.log("");
    }

    public static void init() {
        if (plugin == null) {
            plugin = JustEnoughGuide.getInstance();
        }
    }

    public static void trace(@NotNull Throwable e) {
        Debug.trace(e, null);
    }

    public static void trace(@NotNull Throwable e, @Nullable String doing) {
        Debug.trace(e, doing, null);
    }

    public static void trace(@NotNull Throwable e, @Nullable String doing, @Nullable Integer code) {
        Debug.init();
        plugin.getLogger().severe("DO NOT REPORT THIS ERROR TO JustEnoughGuide DEVELOPERS!!! THIS IS NOT A JustEnoughGuide BUG!");
        if (code != null) {
            plugin.getLogger().severe("Error code: " + code);
        }
        plugin.getLogger().severe("If you are sure that this is a JustEnoughGuide bug, please report to " + JustEnoughGuide.getInstance().getBugTrackerURL());
        if (doing != null) {
            plugin.getLogger().severe("An unexpected error occurred while " + doing);
        } else {
            plugin.getLogger().severe("An unexpected error occurred.");
        }
        e.printStackTrace();
    }
}

