/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.BookmarkRelocation;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class ItemMarkGroup
extends FlexItemGroup {
    private static final ItemStack ICON_BACKGROUND = Lang.getIcon("item-mark-background", Material.GREEN_STAINED_GLASS_PANE);
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    @Deprecated
    private final int BACK_SLOT;
    @Deprecated
    private final int SEARCH_SLOT;
    @Deprecated
    private final int PREVIOUS_SLOT;
    @Deprecated
    private final int NEXT_SLOT;
    @Deprecated
    private final int[] BORDER;
    @Deprecated
    private final int[] MAIN_CONTENT;
    private final JEGSlimefunGuideImplementation implementation;
    private final Player player;
    @NotNull
    private final ItemGroup itemGroup;
    private final int page;
    @NotNull
    private final List<SlimefunItem> slimefunItemList;
    private Map<Integer, ItemMarkGroup> pageMap = new LinkedHashMap<Integer, ItemMarkGroup>();

    public ItemMarkGroup(JEGSlimefunGuideImplementation implementation, @NotNull ItemGroup itemGroup, Player player) {
        this(implementation, itemGroup, player, 1);
    }

    public ItemMarkGroup(JEGSlimefunGuideImplementation implementation, @NotNull ItemGroup itemGroup, Player player, int page) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_item_mark_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        this.page = page;
        this.player = player;
        this.itemGroup = itemGroup;
        this.slimefunItemList = itemGroup.getItems();
        this.implementation = implementation;
        this.pageMap.put(page, this);
        this.BACK_SLOT = 1;
        this.SEARCH_SLOT = 7;
        this.PREVIOUS_SLOT = 46;
        this.NEXT_SLOT = 52;
        this.BORDER = new int[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
        this.MAIN_CONTENT = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    }

    protected ItemMarkGroup(@NotNull ItemMarkGroup itemMarkGroup, int page) {
        this(itemMarkGroup.implementation, itemMarkGroup.itemGroup, itemMarkGroup.player, page);
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        List<Integer> list;
        List<Integer> list2;
        List<Integer> list3;
        List<Integer> list4;
        List<Integer> list5;
        List<Integer> list6;
        BookmarkRelocation relocation;
        ChestMenu chestMenu = new ChestMenu(Lang.getGuideMessage("item-mark-title"));
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        ItemGroup itemGroup = this.itemGroup;
        if (itemGroup instanceof BookmarkRelocation) {
            relocation = (BookmarkRelocation)itemGroup;
            list6 = relocation.getBackButton(this.implementation, player);
        } else {
            list6 = Formats.sub.getChars('b');
        }
        for (Integer n : list6) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(n.intValue(), (pl, s, is, action) -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            });
        }
        ItemGroup itemGroup2 = this.itemGroup;
        if (itemGroup2 instanceof BookmarkRelocation) {
            relocation = (BookmarkRelocation)itemGroup2;
            list5 = relocation.getSearchButton(this.implementation, player);
        } else {
            list5 = Formats.sub.getChars('S');
        }
        for (Integer n : list5) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(n.intValue(), (pl, slot, item, action) -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> this.implementation.openSearch(playerProfile, (String)msg, this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            });
        }
        ItemGroup itemGroup3 = this.itemGroup;
        if (itemGroup3 instanceof BookmarkRelocation) {
            relocation = (BookmarkRelocation)itemGroup3;
            list4 = relocation.getPreviousButton(this.implementation, player);
        } else {
            list4 = Formats.sub.getChars('P');
        }
        for (Integer n : list4) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(n.intValue(), (p, slot, item, action) -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                ItemMarkGroup itemMarkGroup = this.getByPage(Math.max(this.page - 1, 1));
                itemMarkGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            });
        }
        ItemGroup itemGroup4 = this.itemGroup;
        if (itemGroup4 instanceof BookmarkRelocation) {
            relocation = (BookmarkRelocation)itemGroup4;
            list3 = relocation.getNextButton(this.implementation, player);
        } else {
            list3 = Formats.sub.getChars('N');
        }
        for (Integer n : list3) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(n.intValue(), (p, slot, item, action) -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                ItemMarkGroup itemMarkGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1));
                itemMarkGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            });
        }
        ItemGroup itemGroup5 = this.itemGroup;
        if (itemGroup5 instanceof BookmarkRelocation) {
            relocation = (BookmarkRelocation)itemGroup5;
            list2 = relocation.getBorder(this.implementation, player);
        } else {
            list2 = Formats.sub.getChars('B');
        }
        for (Integer n : list2) {
            chestMenu.addItem(n.intValue(), ItemStackUtil.getCleanItem(ICON_BACKGROUND));
            chestMenu.addMenuClickHandler(n.intValue(), ChestMenuUtils.getEmptyClickHandler());
        }
        ItemGroup itemGroup6 = this.itemGroup;
        if (itemGroup6 instanceof BookmarkRelocation) {
            BookmarkRelocation relocation2 = (BookmarkRelocation)itemGroup6;
            list = relocation2.getMainContents(this.implementation, player);
        } else {
            list = Formats.sub.getChars('i');
        }
        List<Integer> contentSlots = list;
        for (int i = 0; i < contentSlots.size(); ++i) {
            ChestMenu.MenuClickHandler handler;
            ItemStack itemstack;
            int n = i + this.page * contentSlots.size() - contentSlots.size();
            if (n >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(n);
            Research research = slimefunItem.getResearch();
            if (this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE && research != null && !playerProfile.hasUnlocked(research)) {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)slimefunItem.getItem()), "&7" + slimefunItem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(player, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())));
                handler = (pl, slot, item, action) -> {
                    research.unlockFromGuide((SlimefunGuideImplementation)this.implementation, pl, playerProfile, slimefunItem, this.itemGroup, this.page);
                    return false;
                };
            } else {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(slimefunItem.getItem(), meta -> {
                    ItemGroup itemGroup = slimefunItem.getItemGroup();
                    List<String> additionLore = List.of("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + LocalHelper.getAddonName(itemGroup, slimefunItem.getId()) + " - " + itemGroup.getDisplayName(player), Lang.getGuideMessage("mark-item"));
                    if (meta.hasLore() && meta.getLore() != null) {
                        List lore = meta.getLore();
                        lore.addAll(additionLore);
                        meta.setLore(lore);
                    } else {
                        meta.setLore(additionLore);
                    }
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }));
                handler = (pl, slot, itm, action) -> {
                    try {
                        JustEnoughGuide.getBookmarkManager().addBookmark(pl, slimefunItem);
                        pl.sendMessage(Lang.getGuideMessage("marked"));
                        pl.playSound(pl.getLocation(), Sounds.COLLECTED_ITEM, 1.0f, 1.0f);
                    }
                    catch (Exception | LinkageError x) {
                        this.printErrorMessage(pl, slimefunItem, x);
                    }
                    return false;
                };
            }
            chestMenu.addItem(contentSlots.get(i).intValue(), ItemStackUtil.getCleanItem(itemstack), handler);
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, this.implementation);
        GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, this.implementation, (ItemGroup)this);
        GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, this.implementation, (ItemGroup)this);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ItemMarkGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        ItemMarkGroup itemMarkGroup = this.pageMap.get(1);
        synchronized (itemMarkGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            ItemMarkGroup itemMarkGroup2 = new ItemMarkGroup(this, page);
            itemMarkGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, itemMarkGroup2);
            return itemMarkGroup2;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(Player p, SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }
}

