/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.core.services.LocalizationService;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Lang {
    public static final ItemStack RAW_INPUT_TEXT_ICON = Lang.getIcon("input-text", Material.PAPER);
    public static final ItemStack INPUT_TEXT_ICON = Converter.getItem(new SlimefunItemStack("_UI_RTS_INPUT_TEXT_ICON", RAW_INPUT_TEXT_ICON));
    public static final ItemStack RAW_RTS_ITEM = Lang.getIcon("guide.real-time-search", Material.ANVIL);
    public static final ItemStack RTS_ITEM = Converter.getItem(new SlimefunItemStack("_UI_RTS_ICON", RAW_RTS_ITEM));
    public static final ItemStack RAW_SPECIAL_MENU_ITEM = Lang.getIcon("guide.special-menu", Material.COMPASS);
    public static final ItemStack SPECIAL_MENU_ITEM = Converter.getItem(new SlimefunItemStack("_UI_SPECIAL_MENU_ICON", RAW_SPECIAL_MENU_ITEM));

    @Nullable
    public static LocalizationService get() {
        return JustEnoughGuide.getInstance().getLocalizationService();
    }

    @NotNull
    public static String getString(@NotNull String path) {
        return Lang.get().getString(path);
    }

    @NotNull
    public static String getString(@NotNull String path, Object ... args) {
        return Lang.decorate(Lang.get().getString(path), args);
    }

    @NotNull
    public static String decorate(String text, Object ... args) {
        for (int i = 0; i < args.length; i += 2) {
            String key = "{" + String.valueOf(args[i]) + "}";
            String value = String.valueOf(args[i + 1]);
            text = text.replace(key, value);
        }
        return text;
    }

    @NotNull
    public static List<String> getStringList(@NotNull String path) {
        return Lang.get().getStringList(path);
    }

    @NotNull
    public static List<String> getStringList(@NotNull String path, Object ... args) {
        List<String> raw = Lang.get().getStringList(path);
        ArrayList<String> decorated = new ArrayList<String>();
        for (String s : raw) {
            decorated.add(Lang.decorate(s, args));
        }
        return decorated;
    }

    @NotNull
    public static @NotNull String @NotNull [] getStringArray(@NotNull String path) {
        return Lang.get().getStringList(path).toArray(new String[0]);
    }

    @NotNull
    public static @NotNull String @NotNull [] getStringArray(@NotNull String path, Object ... args) {
        List<String> raw = Lang.get().getStringList(path);
        ArrayList<String> decorated = new ArrayList<String>();
        for (String s : raw) {
            decorated.add(Lang.decorate(s, args));
        }
        return decorated.toArray(new String[0]);
    }

    @NotNull
    public static String getDebug(String path) {
        return Lang.get().getString("debug." + path);
    }

    @NotNull
    public static String getDebug(String path, Object ... args) {
        return Lang.decorate(Lang.get().getString("debug." + path), args);
    }

    @NotNull
    public static String getItemName(String itemId) {
        return Lang.get().getString("item." + itemId + ".name");
    }

    @NotNull
    public static String getItemName(String itemId, Object ... args) {
        return Lang.decorate(Lang.get().getString("item." + itemId + ".name"), args);
    }

    @NotNull
    public static String getMessage(String path) {
        return Lang.get().getString("message." + path);
    }

    @NotNull
    public static String getMessage(String path, Object ... args) {
        return Lang.decorate(Lang.get().getString("message." + path), args);
    }

    @NotNull
    public static @NotNull String @NotNull [] getItemLore(String itemId) {
        return Lang.get().getStringList("item." + itemId + ".lore").toArray(new String[0]);
    }

    @NotNull
    public static @NotNull String @NotNull [] getItemLore(String itemId, Object ... args) {
        List<String> raw = Lang.get().getStringList("item." + itemId + ".lore");
        ArrayList<String> decorated = new ArrayList<String>();
        for (String s : raw) {
            decorated.add(Lang.decorate(s, args));
        }
        return decorated.toArray(new String[0]);
    }

    @NotNull
    public static String getStartup(String path) {
        return Lang.get().getString("startup." + path);
    }

    @NotNull
    public static String getStartup(String path, Object ... args) {
        return Lang.decorate(Lang.get().getString("startup." + path), args);
    }

    @NotNull
    public static String getShutdown(String path) {
        return Lang.get().getString("shutdown." + path);
    }

    @NotNull
    public static String getShutdown(String path, Object ... args) {
        return Lang.decorate(Lang.get().getString("shutdown." + path), args);
    }

    @NotNull
    public static ItemStack getIcon(String path, @NotNull Material material) {
        String iconName = Lang.getString("icon." + path + ".name");
        String[] iconLore = Lang.getStringArray("icon." + path + ".lore");
        return Converter.getItem(material, iconName, iconLore);
    }

    @NotNull
    public static ItemStack getIcon(String path, @NotNull Material material, Object ... args) {
        String iconName = Lang.getString("icon." + path + ".name", args);
        String[] iconLore = Lang.getStringArray("icon." + path + ".lore", args);
        return Converter.getItem(material, iconName, iconLore);
    }

    @NotNull
    public static ItemStack getGuideGroupIcon(String path, @NotNull Material material) {
        String iconName = Lang.getString("icon.guide-group." + path + ".name");
        String[] iconLore = Lang.getStringArray("icon.guide-group." + path + ".lore");
        return Converter.getItem(material, iconName, iconLore);
    }

    @NotNull
    public static ItemStack getGuideGroupIcon(String path, @NotNull Material material, Object ... args) {
        String iconName = Lang.getString("icon.guide-group." + path + ".name", args);
        String[] iconLore = Lang.getStringArray("icon.guide-group." + path + ".lore", args);
        return Converter.getItem(material, iconName, iconLore);
    }

    @NotNull
    public static String[] getCommandSuccess(String command) {
        return Lang.getStringArray("message.command." + command + ".success");
    }

    @NotNull
    public static String getCommandMessage(String path) {
        return Lang.getString("message.command." + path);
    }

    @NotNull
    public static String getCommandMessage(String command, String path) {
        return Lang.getString("message.command." + command + "." + path);
    }

    @NotNull
    public static String getCommandMessage(String command, String path, Object ... args) {
        return Lang.getString("message.command." + command + "." + path, args);
    }

    @NotNull
    public static String getGuideMessage(String path) {
        return Lang.getMessage("guide." + path);
    }

    @NotNull
    public static String getGuideMessage(String path, Object ... args) {
        return Lang.getMessage("guide." + path, args);
    }

    @NotNull
    public static String getError(String path) {
        return Lang.getString("error." + path);
    }

    @NotNull
    public static String getError(String path, Object ... args) {
        return Lang.decorate(Lang.getString("error." + path), args);
    }

    @Generated
    private Lang() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

