/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.compatibility;

import com.balugaq.jeg.utils.compatibility.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Experimental
public class Converter {
    public static final ItemStack AIR = new ItemStack(Material.AIR);
    @Nullable
    public static final ItemGetter methodHandleSlimefunItemStack_item = Converter.createItemGetter();

    @NotNull
    public static ItemStack getItem(SlimefunItemStack slimefunItemStack) {
        return Converter.asBukkit(slimefunItemStack);
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack) {
        return new CustomItemStack(itemStack).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material) {
        return new CustomItemStack(material).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull Consumer<ItemMeta> itemMetaConsumer) {
        return new CustomItemStack(itemStack, itemMetaConsumer).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @NotNull Consumer<ItemMeta> meta) {
        return new CustomItemStack(material, meta).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @Nullable String name, String ... lore) {
        return new CustomItemStack(itemStack, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, Color color, @Nullable String name, String ... lore) {
        return new CustomItemStack(itemStack, color, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, String name, String ... lore) {
        return new CustomItemStack(material, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, String name, @NotNull List<String> lore) {
        return new CustomItemStack(material, name, lore).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull List<String> list) {
        return new CustomItemStack(itemStack, list).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull Material material, @NotNull List<String> list) {
        return new CustomItemStack(material, list).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @Range(from=1L, to=0x7FFFFFFFL) int amount) {
        return new CustomItemStack(itemStack, amount).asBukkit();
    }

    @NotNull
    public static ItemStack getItem(@NotNull ItemStack itemStack, @NotNull Material material) {
        return new CustomItemStack(itemStack, material).asBukkit();
    }

    @Nullable
    private static ItemGetter createItemGetter() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mt = MethodType.methodType(ItemStack.class);
            MethodHandle handle = lookup.findVirtual(SlimefunItemStack.class, "item", mt);
            return LambdaMetafactory.metafactory(lookup, "getItem", MethodType.methodType(ItemGetter.class), handle.type().generic(), handle, handle.type()).getTarget().invokeExact();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NotNull
    public static ItemStack asBukkit(@Nullable SlimefunItemStack item) {
        ItemStack itemStack;
        if (item == null) {
            return AIR.clone();
        }
        if (ItemStack.class.isInstance(item)) {
            itemStack = (ItemStack)ItemStack.class.cast(item);
        } else if (methodHandleSlimefunItemStack_item != null) {
            try {
                itemStack = (ItemStack)ItemStack.class.cast(methodHandleSlimefunItemStack_item.getItem(item));
            }
            catch (Throwable e) {
                return AIR.clone();
            }
        } else {
            return AIR.clone();
        }
        ItemStack bukkitItem = new ItemStack(itemStack.getType());
        bukkitItem.setAmount(item.getAmount());
        if (item.hasItemMeta()) {
            bukkitItem.setItemMeta(item.getItemMeta());
        }
        return bukkitItem;
    }

    @FunctionalInterface
    public static interface ItemGetter {
        public ItemStack getItem(SlimefunItemStack var1);
    }
}

