/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.listeners;

import com.balugaq.jeg.api.groups.RTSSearchGroup;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.objects.events.RTSEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.LocalHelper;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RTSListener
implements Listener {
    public static final NamespacedKey FAKE_ITEM_KEY = new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "fake_item");
    public static final NamespacedKey CHEAT_AMOUNT_KEY = new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "cheat_amount");
    public static final Map<Player, SlimefunGuideMode> openingPlayers = new HashMap<Player, SlimefunGuideMode>();
    public static final Map<Player, List<ItemStack>> cheatItems = new HashMap<Player, List<ItemStack>>();
    public static final Integer[] FILL_ORDER = new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};

    public static boolean isRTSPlayer(Player player) {
        return openingPlayers.containsKey(player);
    }

    public static boolean isFakeItem(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR && itemStack.getItemMeta().getPersistentDataContainer().get(FAKE_ITEM_KEY, PersistentDataType.STRING) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quitRTS(@NotNull Player player) {
        if (RTSListener.isRTSPlayer(player)) {
            Map<Player, Object> map = openingPlayers;
            synchronized (map) {
                openingPlayers.remove(player);
            }
            map = RTSSearchGroup.RTS_PLAYERS;
            synchronized (map) {
                RTSSearchGroup.RTS_PLAYERS.remove(player);
            }
            map = RTSSearchGroup.RTS_SEARCH_TERMS;
            synchronized (map) {
                RTSSearchGroup.RTS_SEARCH_TERMS.remove(player);
            }
            map = RTSSearchGroup.RTS_SEARCH_GROUPS;
            synchronized (map) {
                RTSSearchGroup.RTS_SEARCH_GROUPS.remove(player);
            }
            map = RTSSearchGroup.RTS_PAGES;
            synchronized (map) {
                RTSSearchGroup.RTS_PAGES.remove(player);
            }
            JustEnoughGuide.getInstance().getRtsBackpackManager().restoreInventoryFor(player);
            if (cheatItems.containsKey(player)) {
                if (player.isOp() || player.hasPermission("slimefun.cheat.items")) {
                    List<ItemStack> items = cheatItems.get(player);
                    for (ItemStack item : items) {
                        player.getInventory().addItem(new ItemStack[]{item});
                    }
                    cheatItems.remove(player);
                } else {
                    cheatItems.remove(player);
                }
            }
        }
    }

    public static String getHash(ItemStack item) {
        ItemMeta meta;
        if (item != null && (item.getType() == Material.PLAYER_HEAD || item.getType() == Material.PLAYER_WALL_HEAD) && (meta = item.getItemMeta()) instanceof SkullMeta) {
            try {
                URL t = ((SkullMeta)meta).getOwnerProfile().getTextures().getSkin();
                String path = t.getPath();
                String[] parts = path.split("/");
                return parts[parts.length - 1];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onOpenRTS(@NotNull RTSEvents.OpenRTSEvent event) {
        Player player = event.getPlayer();
        Debug.debug("[RTS] Opening for " + player.getName());
        Map<Player, Object> map = openingPlayers;
        synchronized (map) {
            openingPlayers.put(player, event.getGuideMode());
        }
        map = RTSSearchGroup.RTS_PLAYERS;
        synchronized (map) {
            RTSSearchGroup.RTS_PLAYERS.put(player, event.getOpeningInventory());
        }
        map = RTSSearchGroup.RTS_PAGES;
        synchronized (map) {
            RTSSearchGroup.RTS_PAGES.put(player, 1);
        }
        JustEnoughGuide.getInstance().getRtsBackpackManager().saveInventoryBackupFor(player);
        JustEnoughGuide.getInstance().getRtsBackpackManager().clearInventoryFor(player);
        ItemStack[] itemStacks = new ItemStack[36];
        for (int i = 0; i < 36; ++i) {
            itemStacks[i] = RTSSearchGroup.PLACEHOLDER.clone();
        }
        player.getInventory().setStorageContents(itemStacks);
        String presetSearchTerm = event.getPresetSearchTerm();
        if (presetSearchTerm != null) {
            Map<Player, String> map2 = RTSSearchGroup.RTS_SEARCH_TERMS;
            synchronized (map2) {
                RTSSearchGroup.RTS_SEARCH_TERMS.put(player, presetSearchTerm);
            }
            RTSEvents.SearchTermChangeEvent e = new RTSEvents.SearchTermChangeEvent(player, player.getOpenInventory(), event.getOpeningInventory(), null, presetSearchTerm, event.getGuideMode());
            Bukkit.getPluginManager().callEvent((Event)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onRTS(@NotNull RTSEvents.SearchTermChangeEvent event) {
        Player player = event.getPlayer();
        Debug.debug("[RTS] Searching for " + player.getName());
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(event.getGuideMode());
        SearchGroup searchGroup = new SearchGroup(implementation, player, event.getNewSearchTerm(), false, true);
        if (RTSListener.isRTSPlayer(player)) {
            Map<Player, Object> map = RTSSearchGroup.RTS_SEARCH_GROUPS;
            synchronized (map) {
                RTSSearchGroup.RTS_SEARCH_GROUPS.put(player, searchGroup);
            }
            map = RTSSearchGroup.RTS_PAGES;
            synchronized (map) {
                RTSSearchGroup.RTS_PAGES.put(player, 1);
            }
            int page = RTSSearchGroup.RTS_PAGES.get(player);
            for (int i = 0; i < FILL_ORDER.length; ++i) {
                int index = i + page * FILL_ORDER.length - FILL_ORDER.length;
                if (index < searchGroup.slimefunItemList.size()) {
                    SlimefunItem slimefunItem = searchGroup.slimefunItemList.get(index);
                    ItemStack fake = this.getFakeItem(slimefunItem, player);
                    player.getInventory().setItem(FILL_ORDER[i].intValue(), fake);
                    continue;
                }
                player.getInventory().setItem(FILL_ORDER[i].intValue(), RTSSearchGroup.PLACEHOLDER.clone());
            }
            AnvilInventory anvilInventory = event.getOpeningInventory();
            anvilInventory.setItem(1, ChestMenuUtils.getPreviousButton((Player)player, (int)page, (int)((searchGroup.slimefunItemList.size() - 1) / FILL_ORDER.length + 1)));
            anvilInventory.setItem(2, ChestMenuUtils.getNextButton((Player)player, (int)page, (int)((searchGroup.slimefunItemList.size() - 1) / FILL_ORDER.length + 1)));
        }
    }

    @EventHandler
    public void onRTSPageChange(@NotNull RTSEvents.PageChangeEvent event) {
        Player player = event.getPlayer();
        Debug.debug("[RTS] Changing page for " + player.getName());
        int page = event.getNewPage();
        SearchGroup searchGroup = RTSSearchGroup.RTS_SEARCH_GROUPS.get(player);
        if (searchGroup != null) {
            for (int i = 0; i < FILL_ORDER.length; ++i) {
                int index = i + page * FILL_ORDER.length - FILL_ORDER.length;
                if (index < searchGroup.slimefunItemList.size()) {
                    SlimefunItem slimefunItem = searchGroup.slimefunItemList.get(index);
                    ItemStack fake = this.getFakeItem(slimefunItem, player);
                    player.getInventory().setItem(FILL_ORDER[i].intValue(), fake);
                    continue;
                }
                player.getInventory().setItem(FILL_ORDER[i].intValue(), RTSSearchGroup.PLACEHOLDER.clone());
            }
            AnvilInventory anvilInventory = RTSSearchGroup.RTS_PLAYERS.get(player);
            anvilInventory.setItem(1, ChestMenuUtils.getPreviousButton((Player)player, (int)page, (int)((searchGroup.slimefunItemList.size() - 1) / FILL_ORDER.length + 1)));
            anvilInventory.setItem(2, ChestMenuUtils.getNextButton((Player)player, (int)page, (int)((searchGroup.slimefunItemList.size() - 1) / FILL_ORDER.length + 1)));
        }
    }

    @EventHandler
    public void onCloseRTS(@NotNull RTSEvents.CloseRTSEvent event) {
        Player player = event.getPlayer();
        RTSListener.quitRTS(player);
    }

    @EventHandler
    public void restore(@NotNull PlayerJoinEvent event) {
        ItemStack[] itemStacks;
        Player player = event.getPlayer();
        RTSListener.quitRTS(player);
        for (ItemStack itemStack : itemStacks = player.getInventory().getContents()) {
            if (!RTSListener.isFakeItem(itemStack)) continue;
            itemStack.setAmount(0);
            itemStack.setType(Material.AIR);
        }
        player.getInventory().setContents(itemStacks);
    }

    @EventHandler
    public void restore(@NotNull PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            RTSListener.quitRTS(player);
        }
    }

    @EventHandler
    public void onQuit(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            RTSListener.quitRTS(player);
        }
    }

    @EventHandler
    public void onDeath(@NotNull PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (RTSListener.isRTSPlayer(player)) {
            RTSListener.quitRTS(player);
            event.setKeepInventory(true);
            event.getDrops().clear();
        }
    }

    @EventHandler
    public void onOpenInventory(@NotNull InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            RTSListener.quitRTS(player);
        }
    }

    @EventHandler
    public void onLookup(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getView().getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            InventoryAction action = event.getAction();
            if (action == InventoryAction.PICKUP_ONE || action == InventoryAction.PICKUP_HALF || action == InventoryAction.PICKUP_ALL || action == InventoryAction.PICKUP_SOME) {
                ItemStack itemStack = event.getCurrentItem();
                if (itemStack == null || itemStack.getType() == Material.AIR) {
                    return;
                }
                SlimefunGuideMode mode = openingPlayers.get(player);
                SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(mode);
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
                if (profile != null) {
                    SlimefunItem slimefunItem = SlimefunItem.getById((String)((String)itemStack.getItemMeta().getPersistentDataContainer().get(FAKE_ITEM_KEY, PersistentDataType.STRING)));
                    if (slimefunItem == null) {
                        event.setCancelled(true);
                        return;
                    }
                    if (mode == SlimefunGuideMode.SURVIVAL_MODE) {
                        RTSSearchGroup back = new RTSSearchGroup(RTSSearchGroup.RTS_PLAYERS.get(player), RTSSearchGroup.RTS_SEARCH_TERMS.get(player), RTSSearchGroup.RTS_PAGES.get(player));
                        profile.getGuideHistory().add((ItemGroup)back, 1);
                        implementation.displayItem(profile, slimefunItem, true);
                        RTSListener.quitRTS(player);
                    } else if (mode == SlimefunGuideMode.CHEAT_MODE) {
                        if (player.isOp() || player.hasPermission("slimefun.cheat.items")) {
                            if (slimefunItem instanceof MultiBlockMachine) {
                                Slimefun.getLocalization().sendMessage((CommandSender)player, "guide.cheat.no-multiblocks");
                            } else {
                                ItemStack clonedItem = slimefunItem.getItem().clone();
                                int addAmount = clonedItem.getMaxStackSize();
                                clonedItem.setAmount(addAmount);
                                cheatItems.putIfAbsent(player, new ArrayList());
                                cheatItems.get(player).add(clonedItem);
                                ItemMeta meta = itemStack.getItemMeta();
                                int originalAmount = (Integer)meta.getPersistentDataContainer().getOrDefault(CHEAT_AMOUNT_KEY, PersistentDataType.INTEGER, (Object)0);
                                int totalAmount = originalAmount + addAmount;
                                meta.getPersistentDataContainer().set(CHEAT_AMOUNT_KEY, PersistentDataType.INTEGER, (Object)totalAmount);
                                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)(ItemUtils.getItemName((ItemStack)clonedItem) + " &cTaken x" + totalAmount)));
                                itemStack.setItemMeta(meta);
                            }
                        } else {
                            Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.no-permission", true);
                        }
                    }
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInteract(@NotNull PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = event.getItem();
        if (RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDrop(@NotNull PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = event.getItemDrop().getItemStack();
        if (RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = event.getItemInHand();
        if (RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSwapHand(@NotNull PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = event.getMainHandItem();
        if (RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack2 = event.getOffHandItem();
        if (RTSListener.isFakeItem(itemStack2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAsyncChat(@NotNull AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArmorStandManipulate(@NotNull PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onChat(@NotNull PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArmor(@NotNull PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = event.getItem();
        if (RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClick(@NotNull InventoryClickEvent event) {
        ItemStack itemStack;
        Player player = (Player)event.getWhoClicked();
        if (!RTSListener.isRTSPlayer(player) && (itemStack = event.getCurrentItem()) != null && RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPickup(@NotNull EntityPickupItemEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && RTSListener.isRTSPlayer(player = (Player)livingEntity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onRightClick(@NotNull PlayerRightClickEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.cancel();
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack != null && RTSListener.isFakeItem(itemStack)) {
            event.cancel();
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInteractEntity(@NotNull PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (RTSListener.isRTSPlayer(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemStack = player.getInventory().getItem(event.getHand());
        if (itemStack != null && RTSListener.isFakeItem(itemStack)) {
            event.setCancelled(true);
            return;
        }
    }

    @Contract(value="null, _ -> null; _, null -> null; !null, !null -> !null")
    public ItemStack getFakeItem(@Nullable SlimefunItem slimefunItem, @Nullable Player player) {
        String hash;
        if (slimefunItem == null || player == null) {
            return null;
        }
        ItemStack legacy = slimefunItem.getItem();
        Material material = legacy.getType();
        ItemStack itemStack = material == Material.PLAYER_HEAD || material == Material.PLAYER_WALL_HEAD ? ((hash = RTSListener.getHash(legacy)) != null ? PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)hash)) : new ItemStack(material)) : new ItemStack(material);
        itemStack.setAmount(legacy.getAmount());
        ItemMeta legacyMeta = legacy.getItemMeta();
        ItemMeta meta = itemStack.getItemMeta();
        ItemGroup itemGroup = slimefunItem.getItemGroup();
        List<CallSite> additionLore = List.of("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + LocalHelper.getAddonName(itemGroup, slimefunItem.getId()) + String.valueOf(ChatColor.WHITE) + " - " + LocalHelper.getDisplayName(itemGroup, player));
        if (legacyMeta.hasLore() && legacyMeta.getLore() != null) {
            List lore = legacyMeta.getLore();
            lore.addAll(additionLore);
            meta.setLore(lore);
        } else {
            meta.setLore(additionLore);
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        meta.getPersistentDataContainer().set(FAKE_ITEM_KEY, PersistentDataType.STRING, (Object)slimefunItem.getId());
        if (legacyMeta.hasDisplayName()) {
            String name = legacyMeta.getDisplayName();
            meta.setDisplayName(" " + name + " ");
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }
}

