/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.interfaces.JEGCommand;
import com.balugaq.jeg.core.commands.HelpCommand;
import com.balugaq.jeg.utils.Lang;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEGCommands
implements TabExecutor {
    private final JavaPlugin plugin;
    private final List<JEGCommand> commands = new ArrayList<JEGCommand>();
    @NotNull
    private final JEGCommand defaultCommand;

    public JEGCommands(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultCommand = new HelpCommand((Plugin)this.plugin);
    }

    public void addCommand(JEGCommand command) {
        this.commands.add(command);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.isOp()) {
            sender.sendMessage(Lang.getCommandMessage("no-permission"));
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(Lang.getCommandMessage("unknown-command"));
            return true;
        }
        for (JEGCommand jegCommand : this.commands) {
            if (!jegCommand.canCommand(sender, command, label, args)) continue;
            jegCommand.onCommand(sender, command, label, args);
            return true;
        }
        this.defaultCommand.onCommand(sender, command, label, args);
        return true;
    }

    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        for (JEGCommand jegCommand : this.commands) {
            List<String> partial = jegCommand.onTabCompleteRaw(sender, args);
            if (partial == null) continue;
            result.addAll(partial);
        }
        return result;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender.isOp()) {
            List<String> raw = this.onTabCompleteRaw(sender, args);
            return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], raw, new ArrayList());
        }
        return List.of();
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public List<JEGCommand> getCommands() {
        return this.commands;
    }

    @NotNull
    @Generated
    public JEGCommand getDefaultCommand() {
        return this.defaultCommand;
    }
}

