/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.JEGCommand;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CacheCommand
implements JEGCommand {
    private final Plugin plugin;

    public CacheCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        switch (args.length) {
            case 1: {
                return List.of("cache");
            }
            case 2: {
                return List.of("1", "2");
            }
            case 3: {
                switch (args[1]) {
                    case "1": {
                        ArrayList<String> result = new ArrayList<String>(SearchGroup.EN_CACHE.keySet().stream().sorted().map(String::valueOf).toList());
                        result.add("clear");
                        return result;
                    }
                    case "2": {
                        ArrayList<String> result = new ArrayList<String>(SearchGroup.EN_CACHE2.keySet().stream().sorted().map(String::valueOf).toList());
                        result.add("clear");
                        return result;
                    }
                }
                return List.of();
            }
        }
        return List.of();
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        return sender.isOp() && args.length >= 1 && "cache".equalsIgnoreCase(args[0]);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        this.onCheck(sender, args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCheck(@NotNull CommandSender sender, @NotNull String[] args) {
        Set<SlimefunItem> set;
        Map<String, Reference<Set<SlimefunItem>>> cache;
        if (args.length < 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /jeg cache <section> <key>");
            return;
        }
        String section = args[1];
        String command = args[2];
        switch (section) {
            case "1": {
                cache = SearchGroup.EN_CACHE;
                break;
            }
            case "2": {
                cache = SearchGroup.EN_CACHE2;
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid section number. Please choose 1 or 2.");
                return;
            }
        }
        if (cache == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid section number. Please choose 1 or 2.");
            return;
        }
        if ("clear".equalsIgnoreCase(command)) {
            cache.clear();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cache " + section + " cleared.");
            return;
        }
        String key = command;
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Checking cache " + section + " for " + key + "...");
        if (!cache.containsKey(key)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Cache for " + key + " is invalid.");
            return;
        }
        Integer size = null;
        Reference<Set<SlimefunItem>> ref = cache.get(key);
        if (ref != null && (set = ref.get()) != null) {
            size = set.size();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Items: ");
            for (SlimefunItem item : set) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + " - " + item.getItemName());
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cache for " + key + " is valid.");
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cache size: " + cache.size());
        if (size == null) return;
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Character set size: " + size);
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

