/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.utils.ItemStackUtil;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GuideUtil {
    private static final ItemStack BOOK_MARK_MENU_BUTTON = ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.NETHER_STAR, "&e&lCollected", new String[0]));
    private static final ItemStack ITEM_MARK_MENU_BUTTON = ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.WRITABLE_BOOK, "&e&lCollecting", new String[0]));

    @ParametersAreNonnullByDefault
    public static void openMainMenuAsync(Player player, SlimefunGuideMode mode, int selectedPage) {
        if (!PlayerProfile.get((OfflinePlayer)player, profile -> Slimefun.runSync(() -> GuideUtil.openMainMenu(player, profile, mode, selectedPage)))) {
            Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.opening-guide");
        }
    }

    @ParametersAreNonnullByDefault
    public static void openMainMenu(Player player, PlayerProfile profile, SlimefunGuideMode mode, int selectedPage) {
        GuideUtil.getGuide(player, mode).openMainMenu(profile, selectedPage);
    }

    @NotNull
    public static SlimefunGuideImplementation getGuide(@NotNull Player player, SlimefunGuideMode mode) {
        if (mode == SlimefunGuideMode.SURVIVAL_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
        }
        if ((player.isOp() || player.hasPermission("slimefun.cheat.items")) && mode == SlimefunGuideMode.CHEAT_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.CHEAT_MODE);
        }
        return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
    }

    public static void removeLastEntry(@NotNull GuideHistory guideHistory) {
        try {
            Method getLastEntry = guideHistory.getClass().getDeclaredMethod("getLastEntry", Boolean.TYPE);
            getLastEntry.setAccessible(true);
            getLastEntry.invoke((Object)guideHistory, true);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public static ItemStack getBookMarkMenuButton() {
        return BOOK_MARK_MENU_BUTTON;
    }

    @NotNull
    public static ItemStack getItemMarkMenuButton() {
        return ITEM_MARK_MENU_BUTTON;
    }

    @Generated
    private GuideUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

