/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarkManager
extends AbstractManager {
    private static final int DATA_ITEM_SLOT = 0;
    @Deprecated
    private static final String BACKPACK_NAME = "JEGBookmarkBackpack";
    @NotNull
    private final NamespacedKey BOOKMARKS_KEY;
    @NotNull
    private final Plugin plugin;

    public BookmarkManager(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.BOOKMARKS_KEY = new NamespacedKey(plugin, "bookmarks");
    }

    public void addBookmark(@NotNull Player player, @NotNull SlimefunItem slimefunItem) {
        PlayerBackpack backpack = this.getOrCreateBookmarkBackpack(player);
        if (backpack == null) {
            return;
        }
        this.addBookmark0(player, backpack, slimefunItem);
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile != null) {
            profile.save();
        }
    }

    private void addBookmark0(@NotNull Player player, @NotNull PlayerBackpack backpack, @NotNull SlimefunItem slimefunItem) {
        ItemStack bookmarksItem = backpack.getInventory().getItem(0);
        if (bookmarksItem == null || bookmarksItem.getType() == Material.AIR) {
            bookmarksItem = this.markItemAsBookmarksItem(new ItemStack(Material.DIRT), player);
        }
        ItemStack itemStack = ItemStackUtil.getCleanItem(Converter.getItem(bookmarksItem, itemMeta -> {
            ArrayList<String> lore = itemMeta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            String id = slimefunItem.getId();
            lore.remove(id);
            lore.add(id);
            itemMeta.setLore(lore);
        }));
        backpack.getInventory().setItem(0, itemStack);
    }

    @Nullable
    public List<SlimefunItem> getBookmarkedItems(@NotNull Player player) {
        PlayerBackpack backpack = this.getBookmarkBackpack(player);
        if (backpack == null) {
            return null;
        }
        ItemStack bookmarksItem = backpack.getInventory().getItem(0);
        if (bookmarksItem == null || bookmarksItem.getType() == Material.AIR) {
            return null;
        }
        if (!this.isBookmarksItem(bookmarksItem, player)) {
            return null;
        }
        ArrayList<SlimefunItem> bookmarkedItems = new ArrayList<SlimefunItem>();
        ItemMeta itemMeta = bookmarksItem.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        List lore = itemMeta.getLore();
        if (lore != null) {
            for (String id : lore) {
                SlimefunItem sfitem = SlimefunItem.getById((String)id);
                if (sfitem == null) continue;
                bookmarkedItems.add(sfitem);
            }
        }
        return bookmarkedItems;
    }

    public void removeBookmark(@NotNull Player player, @NotNull SlimefunItem slimefunItem) {
        PlayerBackpack backpack = this.getBookmarkBackpack(player);
        if (backpack == null) {
            return;
        }
        this.removeBookmark0(backpack, slimefunItem);
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile != null) {
            profile.save();
        }
    }

    private void removeBookmark0(@NotNull PlayerBackpack backpack, @NotNull SlimefunItem slimefunItem) {
        ItemStack bookmarksItem = backpack.getInventory().getItem(0);
        if (bookmarksItem == null || bookmarksItem.getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = ItemStackUtil.getCleanItem(Converter.getItem(bookmarksItem, itemMeta -> {
            List lore = itemMeta.getLore();
            if (lore == null) {
                return;
            }
            lore.remove(slimefunItem.getId());
            itemMeta.setLore(lore);
        }));
        backpack.getInventory().setItem(0, itemStack);
    }

    public void clearBookmarks(@NotNull Player player) {
        PlayerBackpack backpack = this.getBookmarkBackpack(player);
        if (backpack == null) {
            return;
        }
        this.clearBookmarks0(backpack);
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile != null) {
            profile.save();
        }
    }

    private void clearBookmarks0(@NotNull PlayerBackpack backpack) {
        ItemStack bookmarksItem = backpack.getInventory().getItem(0);
        if (bookmarksItem == null || bookmarksItem.getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = ItemStackUtil.getCleanItem(Converter.getItem(bookmarksItem, itemMeta -> itemMeta.setLore(new ArrayList())));
        backpack.getInventory().setItem(0, itemStack);
    }

    @Nullable
    public PlayerBackpack getOrCreateBookmarkBackpack(@NotNull Player player) {
        PlayerBackpack backpack = this.getBookmarkBackpack(player);
        if (backpack == null) {
            backpack = this.createBackpack(player);
        }
        return backpack;
    }

    @Nullable
    public PlayerBackpack createBackpack(@NotNull Player player) {
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile == null) {
            return null;
        }
        PlayerBackpack backpack = profile.createBackpack(9);
        if (backpack == null) {
            return null;
        }
        backpack.getInventory().setItem(0, this.markItemAsBookmarksItem(new ItemStack(Material.DIRT), player));
        backpack.markDirty();
        profile.save();
        return backpack;
    }

    @Nullable
    public PlayerBackpack getBookmarkBackpack(@NotNull Player player) {
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile == null) {
            return null;
        }
        Collection backpacks = profile.getPlayerData().getBackpacks().values();
        if (backpacks == null || backpacks.isEmpty()) {
            return null;
        }
        for (PlayerBackpack backpack : backpacks) {
            Inventory inventory = backpack.getInventory();
            ItemStack[] contents = inventory.getContents();
            ItemStack bookmarksItem = contents[0];
            if (bookmarksItem == null || bookmarksItem.getType() == Material.AIR || !this.isBookmarksItem(bookmarksItem, player)) continue;
            boolean pass = true;
            for (int i = 0; i < contents.length; ++i) {
                if (i == 0 || contents[i] == null || contents[i].getType() == Material.AIR) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            return backpack;
        }
        return null;
    }

    @NotNull
    public ItemStack markItemAsBookmarksItem(@NotNull ItemStack itemStack, @NotNull Player player) {
        return ItemStackUtil.getCleanItem(Converter.getItem(itemStack, itemMeta -> itemMeta.getPersistentDataContainer().set(this.BOOKMARKS_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString())));
    }

    public boolean isBookmarksItem(@NotNull ItemStack itemStack, @NotNull Player player) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        String uuid = (String)itemMeta.getPersistentDataContainer().get(this.BOOKMARKS_KEY, PersistentDataType.STRING);
        return uuid != null && uuid.equals(player.getUniqueId().toString());
    }

    public void unmarkBookmarksItem(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.getPersistentDataContainer().remove(this.BOOKMARKS_KEY);
            itemStack.setItemMeta(itemMeta);
        }
    }

    @NotNull
    @Generated
    public NamespacedKey getBOOKMARKS_KEY() {
        return this.BOOKMARKS_KEY;
    }

    @NotNull
    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

