/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class Language {
    private final String lang;
    private final File currentFile;
    private final FileConfiguration currentConfig;

    @ParametersAreNonnullByDefault
    public Language(String lang, File currentFile, FileConfiguration defaultConfig) {
        Preconditions.checkArgument((lang != null ? 1 : 0) != 0, (Object)"Language key cannot be null");
        Preconditions.checkArgument((currentFile != null ? 1 : 0) != 0, (Object)"Current file cannot be null");
        Preconditions.checkArgument((defaultConfig != null ? 1 : 0) != 0, (Object)"default config cannot be null");
        this.lang = lang;
        this.currentFile = currentFile;
        this.currentConfig = YamlConfiguration.loadConfiguration((File)currentFile);
        this.currentConfig.setDefaults((Configuration)defaultConfig);
        for (String key : defaultConfig.getKeys(true)) {
            if (this.currentConfig.contains(key)) continue;
            this.currentConfig.set(key, defaultConfig.get(key));
        }
        this.save();
    }

    @Nonnull
    public String getName() {
        return this.lang;
    }

    @Nonnull
    public FileConfiguration getLang() {
        return this.currentConfig;
    }

    public void save() {
        try {
            this.currentConfig.save(this.currentFile);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }
}

