/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.events.RTSEvents;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.libraries.anvilgui.AnvilGUI;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class RTSSearchGroup
extends FlexItemGroup {
    public static final ItemStack PLACEHOLDER = Converter.getItem(Converter.getItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "&a", "&a", "&a"), meta -> meta.getPersistentDataContainer().set(RTSListener.FAKE_ITEM_KEY, PersistentDataType.STRING, (Object)"____JEG_FAKE_ITEM____"));
    public static final Map<Player, SearchGroup> RTS_SEARCH_GROUPS = new ConcurrentHashMap<Player, SearchGroup>();
    public static final Map<Player, Integer> RTS_PAGES = new ConcurrentHashMap<Player, Integer>();
    public static final Map<Player, AnvilInventory> RTS_PLAYERS = new ConcurrentHashMap<Player, AnvilInventory>();
    public static final Map<Player, String> RTS_SEARCH_TERMS = new ConcurrentHashMap<Player, String>();
    public static final Function<Player, ItemStack> BACK_ICON = SlimefunOfficialSupporter::getBackButton;
    @Deprecated
    public static final ItemStack INPUT_TEXT_ICON = Lang.getIcon("input-text", Material.PAPER);
    public static final ItemStack AIR_ICON = new ItemStack(Material.AIR);
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final AnvilInventory anvilInventory;
    private final String presetSearchTerm;
    private final int page;

    public RTSSearchGroup(AnvilInventory anvilInventory, String presetSearchTerm) {
        this(anvilInventory, presetSearchTerm, 1);
    }

    public RTSSearchGroup(AnvilInventory anvilInventory, String presetSearchTerm, int page) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_rts_search_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        this.anvilInventory = anvilInventory;
        this.presetSearchTerm = presetSearchTerm;
        this.page = page;
    }

    public static Inventory newRTSInventoryFor(Player player, SlimefunGuideMode guideMode) {
        return RTSSearchGroup.newRTSInventoryFor(player, guideMode, null);
    }

    public static Inventory newRTSInventoryFor(Player player, SlimefunGuideMode guideMode, String presetSearchTerm) {
        return RTSSearchGroup.newRTSInventoryFor(player, guideMode, null, null, presetSearchTerm);
    }

    public static Inventory newRTSInventoryFor(Player player, SlimefunGuideMode guideMode, @Nullable BiConsumer<Integer, AnvilGUI.StateSnapshot> clickHandler, int @Nullable [] slots, @Nullable String presetSearchTerm) {
        Inventory inventory;
        AnvilGUI.Builder builder = new AnvilGUI.Builder().plugin((Plugin)SearchGroup.JAVA_PLUGIN).itemLeft(BACK_ICON.apply(player)).itemRight(Lang.INPUT_TEXT_ICON).itemOutput(AIR_ICON).text("").title(Lang.getGuideMessage("rts-title")).onClose(stateSnapshot -> {
            RTSEvents.CloseRTSEvent event = new RTSEvents.CloseRTSEvent(player, (AnvilGUI.StateSnapshot)stateSnapshot, guideMode);
            Bukkit.getPluginManager().callEvent((Event)event);
        });
        if (clickHandler != null) {
            builder.onClickAsync((slot, stateSnapshot) -> CompletableFuture.supplyAsync(() -> {
                if (slots != null) {
                    for (int s : slots) {
                        if (s != slot) continue;
                        return List.of(AnvilGUI.ResponseAction.run(() -> {
                            RTSEvents.ClickAnvilItemEvent event = new RTSEvents.ClickAnvilItemEvent(player, (AnvilGUI.StateSnapshot)stateSnapshot, (int)slot, guideMode);
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled()) {
                                clickHandler.accept(s, (AnvilGUI.StateSnapshot)stateSnapshot);
                            }
                        }));
                    }
                }
                return Collections.emptyList();
            }));
        } else {
            builder.onClickAsync((slot, stateSnapshot) -> CompletableFuture.supplyAsync(Collections::emptyList));
        }
        if (presetSearchTerm != null) {
            builder.text(presetSearchTerm);
        }
        if ((inventory = builder.open(player).getInventory()) instanceof AnvilInventory) {
            AnvilInventory anvilInventory = (AnvilInventory)inventory;
            RTSEvents.OpenRTSEvent event = new RTSEvents.OpenRTSEvent(player, anvilInventory, guideMode, presetSearchTerm);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        return inventory;
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        RTSSearchGroup.newRTSInventoryFor(player, slimefunGuideMode, (s, stateSnapshot) -> {
            SearchGroup rts;
            if (s == 0) {
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
                if (profile == null) {
                    return;
                }
                GuideHistory history = profile.getGuideHistory();
                history.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                return;
            }
            if (s == 1) {
                SearchGroup rts2 = RTS_SEARCH_GROUPS.get(player);
                if (rts2 != null) {
                    int oldPage = RTS_PAGES.getOrDefault(player, 1);
                    int newPage = Math.max(1, oldPage - 1);
                    RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(player, RTS_PLAYERS.get(player), oldPage, newPage, slimefunGuideMode);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        Map<Player, Integer> map = RTS_PAGES;
                        synchronized (map) {
                            RTS_PAGES.put(player, newPage);
                        }
                    }
                }
            } else if (s == 2 && (rts = RTS_SEARCH_GROUPS.get(player)) != null) {
                int oldPage = RTS_PAGES.getOrDefault(player, 1);
                int newPage = Math.min((rts.slimefunItemList.size() - 1) / RTSListener.FILL_ORDER.length + 1, oldPage + 1);
                RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(player, RTS_PLAYERS.get(player), oldPage, newPage, slimefunGuideMode);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    Map<Player, Integer> map = RTS_PAGES;
                    synchronized (map) {
                        RTS_PAGES.put(player, newPage);
                    }
                }
            }
        }, new int[]{0, 1, 2}, this.presetSearchTerm);
        Map<Player, Integer> map = RTS_PAGES;
        synchronized (map) {
            RTS_PAGES.put(player, this.page);
        }
        RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(player, RTS_PLAYERS.get(player), this.page, this.page, slimefunGuideMode);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Generated
    public AnvilInventory getAnvilInventory() {
        return this.anvilInventory;
    }

    @Generated
    public String getPresetSearchTerm() {
        return this.presetSearchTerm;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    static {
        Bukkit.getScheduler().runTaskTimer((Plugin)SearchGroup.JAVA_PLUGIN, () -> {
            HashMap<Player, String> searchTermCopy;
            HashMap<Player, AnvilInventory> copy;
            Map<Player, AnvilInventory> map = RTS_PLAYERS;
            synchronized (map) {
                copy = new HashMap<Player, AnvilInventory>(RTS_PLAYERS);
            }
            Map<Player, String> map2 = RTS_SEARCH_TERMS;
            synchronized (map2) {
                searchTermCopy = new HashMap<Player, String>(RTS_SEARCH_TERMS);
            }
            HashMap<Player, String> writes = new HashMap<Player, String>();
            copy.forEach((player, inventory) -> {
                if (inventory == null) {
                    return;
                }
                InventoryView view = player.getOpenInventory();
                Inventory openingInventory = view.getTopInventory();
                if (openingInventory instanceof AnvilInventory) {
                    AnvilInventory anvilInventory = (AnvilInventory)openingInventory;
                    if (openingInventory.equals(inventory)) {
                        String oldSearchTerm = (String)searchTermCopy.get(player);
                        String newSearchTerm = anvilInventory.getRenameText();
                        if (oldSearchTerm == null || newSearchTerm == null) {
                            writes.put((Player)player, newSearchTerm);
                            return;
                        }
                        if (!oldSearchTerm.equals(newSearchTerm)) {
                            writes.put((Player)player, newSearchTerm);
                            RTSEvents.SearchTermChangeEvent event = new RTSEvents.SearchTermChangeEvent((Player)player, view, anvilInventory, oldSearchTerm, newSearchTerm, GuideListener.guideModeMap.get(player));
                            Bukkit.getPluginManager().callEvent((Event)event);
                        }
                    }
                }
            });
            writes.forEach((player, searchTerm) -> {
                if (player != null && searchTerm != null) {
                    Map<Player, String> map = RTS_SEARCH_TERMS;
                    synchronized (map) {
                        RTS_SEARCH_TERMS.put((Player)player, (String)searchTerm);
                    }
                }
            });
        }, 1L, 4L);
    }
}

