/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@NotDisplayInCheatMode
public abstract class GuideGroup
extends FlexItemGroup {
    private static final int PREVIOUS_SLOT = 46;
    private static final int NEXT_SLOT = 52;
    private final Map<Integer, Set<Integer>> slots = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, Map<Integer, ItemStack>> contents = new HashMap<Integer, Map<Integer, ItemStack>>();
    private final Map<Integer, Map<Integer, ChestMenu.MenuClickHandler>> clickHandlers = new HashMap<Integer, Map<Integer, ChestMenu.MenuClickHandler>>();

    protected GuideGroup(@NotNull NamespacedKey key, @NotNull ItemStack icon) {
        super(key, icon);
    }

    protected GuideGroup(@NotNull NamespacedKey key, @NotNull ItemStack icon, int tier) {
        super(key, icon, tier);
    }

    @NotNull
    public GuideGroup addGuide(@Range(from=1L, to=127L) int page, @Range(from=9L, to=44L) int slot, @NotNull ItemStack itemStack, @NotNull ChestMenu.MenuClickHandler handler) {
        Preconditions.checkArgument((slot >= 9 && slot <= 44 ? 1 : 0) != 0, (Object)"Slot must be between 9 and 44");
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Item must not be null");
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Handler must not be null");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Item must not be air");
        Preconditions.checkArgument((boolean)itemStack.getType().isItem(), (Object)"Item must be an item");
        Preconditions.checkArgument((this.slots.size() <= this.getContentSlots().length ? 1 : 0) != 0, (Object)"Too many guides in this group. Maximum of 36 allowed.");
        this.slots.computeIfAbsent(page, k -> new HashSet()).add(slot);
        this.contents.computeIfAbsent(page, k -> new LinkedHashMap()).put(slot, itemStack);
        this.clickHandlers.computeIfAbsent(page, k -> new LinkedHashMap()).put(slot, handler);
        return this;
    }

    @NotNull
    public GuideGroup addGuide(@Range(from=9L, to=44L) int slot, @NotNull ItemStack itemStack, @NotNull ChestMenu.MenuClickHandler handler) {
        return this.addGuide(1, slot, itemStack, handler);
    }

    @NotNull
    public GuideGroup addGuide(@Range(from=9L, to=44L) int slot, @NotNull ItemStack itemStack) {
        return this.addGuide(slot, itemStack, ChestMenuUtils.getEmptyClickHandler());
    }

    @NotNull
    public GuideGroup addGuide(@NotNull ItemStack itemStack, @NotNull ChestMenu.MenuClickHandler handler, @Range(from=1L, to=127L) int page) {
        return this.addGuide(this.findEmptySlot(page), itemStack, handler);
    }

    @NotNull
    public GuideGroup addGuide(@NotNull ItemStack itemStack, @Range(from=1L, to=127L) int page) {
        return this.addGuide(itemStack, ChestMenuUtils.getEmptyClickHandler(), page);
    }

    private int findEmptySlot(int page) {
        for (int i = 0; i < 54; ++i) {
            if (((Set)this.slots.getOrDefault(page, new HashSet())).contains(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return true;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        this.open(player, playerProfile, slimefunGuideMode, 1);
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode, @Range(from=1L, to=127L) int page) {
        if (page < 1 || page > this.contents.size()) {
            return;
        }
        SlimefunGuideImplementation guide = GuideUtil.getGuide(player, slimefunGuideMode);
        playerProfile.getGuideHistory().add((ItemGroup)this, page);
        if (guide instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)guide;
            ChestMenu menu = new ChestMenu(this.getDisplayName(player));
            if (this.isClassic()) {
                jeg.createHeader(player, playerProfile, menu);
            }
            menu.addItem(this.getBackSlot(), ItemStackUtil.getCleanItem(ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            menu.addMenuClickHandler(this.getBackSlot(), (pl, s, is, action) -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE));
                }
                return false;
            });
            for (Map.Entry entry : ((Map)this.contents.getOrDefault(page, new LinkedHashMap())).entrySet()) {
                menu.addItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
            }
            for (Map.Entry entry : ((Map)this.clickHandlers.getOrDefault(page, new LinkedHashMap())).entrySet()) {
                menu.addMenuClickHandler(((Integer)entry.getKey()).intValue(), (ChestMenu.MenuClickHandler)entry.getValue());
            }
            menu.addItem(46, ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)player, (int)page, (int)((this.contents.size() - 1) / 36 + 1))));
            menu.addMenuClickHandler(46, (p, slot, item, action) -> {
                if (page - 1 < 1) {
                    return false;
                }
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                this.open(player, playerProfile, slimefunGuideMode, Math.max(1, page - 1));
                return false;
            });
            menu.addItem(52, ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)player, (int)page, (int)((this.contents.size() - 1) / 36 + 1))));
            menu.addMenuClickHandler(52, (p, slot, item, action) -> {
                if (page + 1 > this.contents.size()) {
                    return false;
                }
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                this.open(player, playerProfile, slimefunGuideMode, Math.min(this.contents.size(), page + 1));
                return false;
            });
            menu.open(new Player[]{player});
        } else {
            player.sendMessage("\u00a7cJEG has already been disabled!");
        }
    }

    public abstract int getSize();

    public abstract boolean isClassic();

    public abstract int[] getContentSlots();

    public abstract int getBackSlot();

    @Generated
    public Map<Integer, Set<Integer>> getSlots() {
        return this.slots;
    }

    @Generated
    public Map<Integer, Map<Integer, ItemStack>> getContents() {
        return this.contents;
    }

    @Generated
    public Map<Integer, Map<Integer, ChestMenu.MenuClickHandler>> getClickHandlers() {
        return this.clickHandlers;
    }
}

