/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TomeOfEnlightenment
extends SimpleSlimefunItem<ItemUseHandler> {
    private final Random random = new Random();

    public TomeOfEnlightenment(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @NotNull
    public ItemUseHandler getItemHandler() {
        return event -> {
            Player player = event.getPlayer();
            PlayerProfile.get((OfflinePlayer)player, profile -> {
                List<Research> unlockableResearches = this.getAffordableResearch(player, (PlayerProfile)profile);
                if (unlockableResearches.isEmpty()) {
                    player.sendMessage("\u00a7cNot enough XP or you have unlocked all researches.");
                    return;
                }
                Research randomResearch = unlockableResearches.get(this.random.nextInt(unlockableResearches.size()));
                int cost = randomResearch.getCost();
                if (profile.hasUnlocked(randomResearch)) {
                    return;
                }
                if (player.getLevel() >= cost) {
                    player.setLevel(player.getLevel() - cost);
                    randomResearch.unlock(player, true);
                }
            });
        };
    }

    private List<Research> getAffordableResearch(Player player, PlayerProfile profile) {
        ArrayList<Research> affordableResearches = new ArrayList<Research>();
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (!research.isEnabled() || research.getCost() > player.getLevel() || research.getAffectedItems().isEmpty() || !research.canUnlock(player) || profile.hasUnlocked(research)) continue;
            affordableResearches.add(research);
        }
        return affordableResearches;
    }
}

