/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.slimefun.items.Magnetoid;
import me.bunnky.idreamofeasy.slimefun.tasks.MagnetoidTask;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MagnetoidListener
implements Listener {
    public static final Map<UUID, BukkitTask> activeTasks = new HashMap<UUID, BukkitTask>();

    public MagnetoidListener(@Nonnull IDreamOfEasy plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::checkAllPlayersForMagnetoid, 0L, 10L);
    }

    private void checkAllPlayersForMagnetoid() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getGameMode() != GameMode.SPECTATOR) {
                this.handleMagnetoid(p);
                continue;
            }
            this.cancelTask(p);
        }
    }

    private void handleMagnetoid(Player p) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)p.getInventory().getItemInOffHand());
        if (sfItem instanceof Magnetoid) {
            Magnetoid magnetoid = (Magnetoid)sfItem;
            if (!activeTasks.containsKey(p.getUniqueId()) && magnetoid.canUse(p, true)) {
                BukkitTask task = new MagnetoidTask(p, magnetoid.getR(), magnetoid).runTaskTimer((Plugin)IDreamOfEasy.getInstance(), 0L, 10L);
                activeTasks.put(p.getUniqueId(), task);
            }
        } else {
            this.cancelTask(p);
        }
    }

    public void cancelTask(Player p) {
        if (activeTasks.containsKey(p.getUniqueId())) {
            activeTasks.get(p.getUniqueId()).cancel();
            activeTasks.remove(p.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.cancelTask(e.getPlayer());
    }
}

