/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.ExplosiveShovel;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ElectricExplosiveShovel
extends ExplosiveShovel
implements Rechargeable {
    private final float cap;
    private static final float COST = 0.3f;

    public ElectricExplosiveShovel(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, float cap) {
        super(itemGroup, item, recipeType, recipe);
        IDOEUtility.setGlow(item);
        this.cap = cap;
        this.addItemHandler(new ItemHandler[]{this.onRightClick()});
    }

    public ItemUseHandler onRightClick() {
        return PlayerRightClickEvent::cancel;
    }

    @NotNull
    public ToolUseHandler getItemHandler() {
        return (e, tool, fortune, drops) -> {
            Player p = e.getPlayer();
            ItemStack itemInHand = p.getInventory().getItemInMainHand();
            if (!this.removeItemCharge(itemInHand, 0.3f)) {
                e.setCancelled(true);
                return;
            }
            super.getItemHandler().onToolUse(e, tool, fortune, drops);
        };
    }

    public float getMaxItemCharge(ItemStack itemStack) {
        return this.cap;
    }

    protected boolean canBreak(@NotNull Player p, @NotNull Block b) {
        ItemStack itemInHand = p.getInventory().getItemInMainHand();
        return this.removeItemCharge(itemInHand, 0.3f) && super.canBreak(p, b);
    }
}

