/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.protection.modules;

import io.github.bakedlibs.dough.protection.Interaction;
import io.github.bakedlibs.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import net.william278.husktowns.api.BukkitHuskTownsAPI;
import net.william278.husktowns.libraries.cloplib.operation.Operation;
import net.william278.husktowns.libraries.cloplib.operation.OperationPosition;
import net.william278.husktowns.libraries.cloplib.operation.OperationType;
import net.william278.husktowns.libraries.cloplib.operation.OperationUser;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class HuskTownsProtectionModule
implements ProtectionModule {
    private BukkitHuskTownsAPI huskTownsAPI;
    private final Plugin plugin;

    public HuskTownsProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.huskTownsAPI = BukkitHuskTownsAPI.getInstance();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (!p.isOnline()) {
            return false;
        }
        return this.huskTownsAPI.isOperationAllowed(Operation.of((OperationUser)this.huskTownsAPI.getOnlineUser(p.getPlayer()), (OperationType)this.getHuskTownsAction(action), (OperationPosition)this.huskTownsAPI.getPosition(l)));
    }

    @Nonnull
    public OperationType getHuskTownsAction(@Nonnull Interaction doughAction) {
        switch (doughAction) {
            case BREAK_BLOCK: {
                return OperationType.BLOCK_BREAK;
            }
            case PLACE_BLOCK: {
                return OperationType.BLOCK_PLACE;
            }
            case ATTACK_ENTITY: {
                return OperationType.PLAYER_DAMAGE_ENTITY;
            }
            case ATTACK_PLAYER: {
                return OperationType.PLAYER_DAMAGE_PLAYER;
            }
            case INTERACT_BLOCK: {
                return OperationType.BLOCK_INTERACT;
            }
        }
        return OperationType.ENTITY_INTERACT;
    }
}

