/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DoughTimings {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.########");
    private final String name;
    private final List<Long> steps = new ArrayList<Long>();
    private final Logger logger;

    public DoughTimings(@Nonnull Plugin plugin, @Nonnull String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        this.name = name;
        this.logger = plugin.getLogger();
    }

    public void step() {
        this.steps.add(System.nanoTime());
    }

    @Nonnull
    public String buildTimings(boolean clearTimings) {
        StringBuilder sb = new StringBuilder("-- Timings " + this.name + " (" + this.steps.size() + ") --");
        int step = 1;
        long lastStep = 0L;
        if (this.steps.size() >= 2) {
            for (long l : this.steps) {
                if (step != 1) {
                    sb.append("\n  Step ").append(step).append(". ").append(l - lastStep).append("ns (").append(FORMAT.format((double)(l - lastStep) / 1000000.0)).append("ms)");
                }
                lastStep = l;
                ++step;
            }
        }
        long totalNs = this.steps.get(this.steps.size() - 1) - this.steps.get(0);
        sb.append("\n  Total: ").append(totalNs).append("ns (").append(FORMAT.format((double)totalNs / 1000000.0)).append("ms)");
        this.logger.info(sb.toString());
        if (clearTimings) {
            this.steps.clear();
        }
        return sb.toString();
    }

    public void logTimings() {
        this.logTimings(true, this.logger::info);
    }

    public void logTimings(boolean clearTimings) {
        this.logTimings(clearTimings, this.logger::info);
    }

    public void logTimings(boolean clearTimings, @Nonnull CommandSender sender) {
        this.logTimings(clearTimings, arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }

    private void logTimings(boolean clearTimings, @Nonnull Consumer<String> printer) {
        printer.accept(this.buildTimings(clearTimings));
    }
}

