/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import java.util.Collection;
import java.util.List;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TrimVault
extends SlimefunItem {
    public TrimVault(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        IDOEUtility.setGlow(item);
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(this, false){

            public void onPlayerPlace(@NotNull BlockPlaceEvent e) {
                Location placedLocation = e.getBlock().getLocation();
                World w = placedLocation.getWorld();
                if (w != null) {
                    w.spawnParticle(Particle.EGG_CRACK, placedLocation.add(0.5, 0.5, 0.5), 30, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(this, false, true){

            public void onPlayerBreak(@NotNull BlockBreakEvent e, @NotNull ItemStack stack, @NotNull List<ItemStack> list) {
                Player p = e.getPlayer();
                ItemStack randTemp = IDOEUtility.getRandomTemplate();
                if (randTemp != null) {
                    p.getWorld().dropItem(e.getBlock().getLocation(), randTemp);
                }
            }
        }});
    }

    @NotNull
    public Collection<ItemStack> getDrops() {
        return List.of(new ItemStack(Material.AIR));
    }
}

