/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.bakedlibs.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.HashMap;
import java.util.UUID;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AlarmClock
extends SlimefunItem {
    private final HashMap<UUID, Long> playerTimers = new HashMap();
    private final HashMap<UUID, Boolean> alarmMode = new HashMap();
    private final HashMap<UUID, BukkitRunnable> alarmTasks = new HashMap();

    public AlarmClock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        IDOEUtility.setGlow(item);
        this.addItemHandler(new ItemHandler[]{this.onUse()});
    }

    private ItemUseHandler onUse() {
        return e -> {
            Player p = e.getPlayer();
            UUID playerId = p.getUniqueId();
            this.cancelAlarm(playerId);
            if (p.isSneaking()) {
                boolean isAlarmMode = this.alarmMode.getOrDefault(playerId, false);
                this.alarmMode.put(playerId, !isAlarmMode);
                if (!this.alarmMode.get(playerId).booleanValue()) {
                    this.cancelAlarm(playerId);
                    p.sendMessage("\u00a7cAlarm mode is now disabled.");
                } else {
                    p.sendMessage("\u00a7aAlarm mode enabled.");
                }
            } else {
                p.sendMessage("\u00a7aEnter timer length in seconds");
                ChatInput.waitForPlayer((Plugin)IDreamOfEasy.getInstance(), p, msg -> {
                    try {
                        long duration = Long.parseLong(msg) * 1000L;
                        long endTime = System.currentTimeMillis() + duration;
                        this.playerTimers.put(playerId, endTime);
                        p.sendMessage("\u00a7eTimer set for \u00a7f" + duration / 1000L + "\u00a7es.");
                        this.startTimer(p);
                    }
                    catch (NumberFormatException ex) {
                        p.sendMessage("\u00a7cInvalid input. Please enter a valid number in seconds.");
                    }
                });
            }
        };
    }

    private void startTimer(final Player player) {
        final UUID playerId = player.getUniqueId();
        new BukkitRunnable(){

            public void run() {
                Long endTime = AlarmClock.this.playerTimers.get(playerId);
                if (endTime == null) {
                    return;
                }
                long remainingTime = endTime - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 2.0f);
                    Bukkit.getScheduler().runTaskLater((Plugin)IDreamOfEasy.getInstance(), () -> player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.5f), 2L);
                    Bukkit.getScheduler().runTaskLater((Plugin)IDreamOfEasy.getInstance(), () -> player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f), 4L);
                    AlarmClock.this.playerTimers.remove(playerId);
                    this.cancel();
                    player.sendMessage("\u00a7eTime's up!");
                    if (AlarmClock.this.alarmMode.getOrDefault(playerId, false).booleanValue()) {
                        AlarmClock.this.startAlarmTask(player.getUniqueId());
                    }
                }
            }
        }.runTaskTimer((Plugin)IDreamOfEasy.getInstance(), 0L, 0L);
    }

    private void startAlarmTask(final UUID playerId) {
        BukkitRunnable alarmTask = new BukkitRunnable(){

            public void run() {
                if (AlarmClock.this.alarmMode.getOrDefault(playerId, false).booleanValue()) {
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 2.0f);
                        Bukkit.getScheduler().runTaskLater((Plugin)IDreamOfEasy.getInstance(), () -> player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.5f), 2L);
                        Bukkit.getScheduler().runTaskLater((Plugin)IDreamOfEasy.getInstance(), () -> player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f), 4L);
                    }
                } else {
                    this.cancel();
                }
            }
        };
        alarmTask.runTaskTimer((Plugin)IDreamOfEasy.getInstance(), 0L, 10L);
        this.alarmTasks.put(playerId, alarmTask);
    }

    private void cancelAlarm(UUID playerId) {
        BukkitRunnable task = this.alarmTasks.get(playerId);
        if (task != null) {
            task.cancel();
            this.alarmTasks.remove(playerId);
        }
    }
}

