/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.protection.modules;

import io.github.bakedlibs.dough.protection.Interaction;
import io.github.bakedlibs.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.LandWorld;
import me.angeschossen.lands.api.player.LandPlayer;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LandsProtectionModule
implements ProtectionModule {
    private LandsIntegration landsIntegration;
    private final Plugin lands;
    private final Plugin plugin;

    public LandsProtectionModule(@Nonnull Plugin lands, @Nonnull Plugin plugin) {
        this.lands = lands;
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.lands;
    }

    @Override
    public void load() {
        this.landsIntegration = LandsIntegration.of((Plugin)this.plugin);
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        LandWorld landWorld = this.landsIntegration.getWorld(l.getWorld());
        if (landWorld == null) {
            return true;
        }
        LandPlayer landPlayer = this.landsIntegration.getLandPlayer(p.getUniqueId());
        if (landPlayer == null) {
            return landWorld.hasRoleFlag(p.getUniqueId(), l, this.convert(action));
        }
        return landWorld.hasRoleFlag(landPlayer, l, this.convert(action), null, false);
    }

    @Nonnull
    private RoleFlag convert(@Nonnull Interaction protectableAction) {
        switch (protectableAction) {
            case PLACE_BLOCK: {
                return Flags.BLOCK_PLACE;
            }
            case BREAK_BLOCK: {
                return Flags.BLOCK_BREAK;
            }
            case INTERACT_BLOCK: {
                return Flags.INTERACT_CONTAINER;
            }
            case ATTACK_PLAYER: {
                return Flags.ATTACK_PLAYER;
            }
            case ATTACK_ENTITY: {
                return Flags.ATTACK_ANIMAL;
            }
        }
        return Flags.INTERACT_VILLAGER;
    }
}

