/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.items;

import io.papermc.lib.PaperLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;

@ParametersAreNonnullByDefault
public final class ItemStackUtil {
    private ItemStackUtil() {
        throw new IllegalStateException("Static utility class cannot be instantiated");
    }

    public static Consumer<ItemMeta> editDisplayName(@Nullable String name) {
        return meta -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
        };
    }

    public static Consumer<ItemMeta> editLore(String ... lore) {
        return ItemStackUtil.editLore(Arrays.asList(lore));
    }

    public static Consumer<ItemMeta> editLore(@Nonnull List<String> lore) {
        return meta -> {
            if (lore.isEmpty()) {
                meta.setLore(Collections.emptyList());
                return;
            }
            ArrayList newLore = new ArrayList(lore);
            newLore.replaceAll(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            meta.setLore(newLore);
        };
    }

    public static Consumer<ItemMeta> editColor(@Nonnull Color color) {
        return meta -> {
            if (meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(color);
            }
            if (meta instanceof PotionMeta) {
                ((PotionMeta)meta).setColor(color);
            }
        };
    }

    public static Consumer<ItemMeta> editCustomModelData(@Nullable Integer data) {
        return meta -> meta.setCustomModelData(data);
    }

    public static Consumer<ItemMeta> editCustomModelData(int data) {
        return meta -> meta.setCustomModelData(data == 0 ? null : Integer.valueOf(data));
    }

    public static Consumer<ItemMeta> appendItemFlags(ItemFlag ... flags) {
        return meta -> meta.addItemFlags(flags);
    }

    public static boolean editMeta(ItemStack itemStack, Consumer<ItemMeta> consumer) {
        if (PaperLib.isPaper()) {
            return itemStack.editMeta(consumer);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            consumer.accept(itemMeta);
        }
        return itemStack.setItemMeta(itemMeta);
    }
}

