/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class ElectricPoisonExtractor
extends AContainer
implements RecipeDisplayItem {
    public ElectricPoisonExtractor(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    protected void registerDefaultRecipes() {
        this.registerRecipe(4, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.POISONOUS_POTATO)}, new ItemStack[]{this.createPoisonPotion(PotionType.STRONG_POISON)});
        this.registerRecipe(6, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.PUFFERFISH)}, new ItemStack[]{this.createPoisonPotion(PotionType.LONG_POISON)});
        this.registerRecipe(6, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.SPIDER_EYE, 2)}, new ItemStack[]{this.createPoisonPotion(PotionType.POISON)});
        this.registerRecipe(8, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.ROTTEN_FLESH, 8)}, new ItemStack[]{this.createPoisonPotion(PotionType.POISON)});
        this.registerRecipe(4, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.RED_MUSHROOM, 4)}, new ItemStack[]{this.createPoisonPotion(PotionType.POISON)});
        this.registerRecipe(4, new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE), new ItemStack(Material.BROWN_MUSHROOM, 4)}, new ItemStack[]{this.createPoisonPotion(PotionType.POISON)});
    }

    private ItemStack createPoisonPotion(PotionType type) {
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        if (potionMeta != null) {
            switch (type) {
                case LONG_POISON: {
                    potionMeta.setBasePotionType(PotionType.LONG_POISON);
                    break;
                }
                case STRONG_POISON: {
                    potionMeta.setBasePotionType(PotionType.STRONG_POISON);
                    break;
                }
                default: {
                    potionMeta.setBasePotionType(PotionType.POISON);
                }
            }
            potion.setItemMeta((ItemMeta)potionMeta);
        }
        return potion;
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.recipes.size() * 2);
        for (MachineRecipe recipe : this.recipes) {
            displayRecipes.add(recipe.getInput()[recipe.getInput().length - 1]);
            displayRecipes.add(recipe.getOutput()[0]);
        }
        return displayRecipes;
    }

    public ItemStack getProgressBar() {
        return this.createPoisonPotion(PotionType.POISON);
    }

    @NotNull
    public String getMachineIdentifier() {
        return "IDOE_ELECTRIC_POISON_EXTRACTOR";
    }
}

