/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class LavaBoat
extends SlimefunItem
implements Listener {
    public LavaBoat(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        IDreamOfEasy.getInstance().getJavaPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)IDreamOfEasy.getInstance());
        IDOEUtility.setGlow(item);
        this.addItemHandler(new ItemHandler[]{e -> {
            SlimefunItem hand = SlimefunItem.getByItem((ItemStack)e.getItem());
            if (!(hand instanceof LavaBoat)) {
                return;
            }
            e.cancel();
            Player p = e.getPlayer();
            this.spawnLavaBoat(p);
            if (p.getGameMode() == GameMode.SURVIVAL) {
                e.getItem().subtract(1);
            }
        }});
    }

    public void spawnLavaBoat(Player p) {
        Boat boat = (Boat)p.getWorld().spawn(p.getLocation(), Boat.class);
        boat.setBoatType(Boat.Type.DARK_OAK);
        boat.setGlowing(true);
        boat.setMetadata("lava_boat", (MetadataValue)new FixedMetadataValue((Plugin)IDreamOfEasy.getInstance(), (Object)true));
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = sb.getTeam("LavaBoats");
        if (team == null) {
            team = sb.registerNewTeam("LavaBoats");
            team.setColor(ChatColor.DARK_RED);
        }
        team.addEntry(boat.getUniqueId().toString());
        boat.setFireTicks(0);
    }

    @EventHandler
    public void onBoatDestroy(@NotNull VehicleDestroyEvent e) {
        Boat boat;
        Vehicle vehicle = e.getVehicle();
        if (vehicle instanceof Boat && (boat = (Boat)vehicle).hasMetadata("lava_boat")) {
            if (!(e.getAttacker() instanceof Player)) {
                e.setCancelled(true);
                return;
            }
            e.setCancelled(true);
            boat.removeMetadata("lava_boat", (Plugin)IDreamOfEasy.getInstance());
            boat.remove();
            ItemStack sfItem = SlimefunItem.getById((String)"IDOE_LAVABOAT").getItem();
            boat.getWorld().dropItemNaturally(boat.getLocation(), sfItem);
        }
    }

    @EventHandler
    public void onMove(@NotNull VehicleMoveEvent e) {
        Boat boat;
        Vehicle vehicle = e.getVehicle();
        if (vehicle instanceof Boat && (boat = (Boat)vehicle).hasMetadata("lava_boat")) {
            World w = boat.getWorld();
            Location loc = boat.getLocation();
            if (e.getTo().clone().subtract(0.0, 0.1, 0.0).getBlock().getType() == Material.WATER || e.getTo().clone().add(0.0, 0.1, 0.0).getBlock().getType() == Material.WATER) {
                boat.removeMetadata("lava_boat", (Plugin)IDreamOfEasy.getInstance());
                boat.remove();
                ItemStack sfItem = SlimefunItem.getById((String)"IDOE_LAVABOAT").getItem();
                boat.getWorld().dropItem(boat.getLocation(), sfItem);
            }
            if (e.getTo().clone().subtract(0.0, 0.1, 0.0).getBlock().getType() == Material.LAVA) {
                e.getVehicle().setGravity(false);
                boat.setFireTicks(0);
                Material blockAbove = w.getBlockAt(loc.clone().add(0.0, 0.1, 0.0)).getType();
                if (blockAbove == Material.LAVA) {
                    boat.setVelocity(new Vector(boat.getVelocity().getX(), 0.1, boat.getVelocity().getZ()));
                }
            } else {
                e.getVehicle().setGravity(true);
            }
        }
    }

    @EventHandler
    public void onCombust(EntityCombustEvent e) {
        Boat boat;
        Object object;
        SlimefunItem sfItem = SlimefunItem.getById((String)"IDOE_LAVABOAT");
        if (sfItem instanceof LavaBoat) {
            e.setCancelled(true);
        }
        if ((object = e.getEntity()) instanceof Player) {
            Boat boat2;
            Entity entity;
            Player p = (Player)object;
            if (p.isInsideVehicle() && (entity = p.getVehicle()) instanceof Boat && (boat2 = (Boat)entity).hasMetadata("lava_boat")) {
                e.setCancelled(true);
                p.setFireTicks(0);
            } else {
                e.setCancelled(false);
            }
        }
        if ((object = e.getEntity()) instanceof Boat && (boat = (Boat)object).hasMetadata("lava_boat")) {
            e.setCancelled(true);
            boat.setFireTicks(0);
            if (!boat.getPassengers().isEmpty()) {
                for (Entity passenger : boat.getPassengers()) {
                    if (!(passenger instanceof Player)) continue;
                    passenger.setFireTicks(0);
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onVehicleDamage(@NotNull VehicleDamageEvent e) {
        Boat boat;
        Vehicle vehicle = e.getVehicle();
        if (vehicle instanceof Boat && (boat = (Boat)vehicle).hasMetadata("lava_boat") && !(e.getAttacker() instanceof Player)) {
            e.setCancelled(true);
            e.getVehicle().setFireTicks(0);
        }
    }

    @EventHandler
    public void onDamage(@NotNull EntityDamageEvent e) {
        Item item;
        Entity sfItem;
        Entity entity = e.getEntity();
        if (entity instanceof Item && (sfItem = SlimefunItem.getByItem((ItemStack)(item = (Item)entity).getItemStack())) instanceof LavaBoat) {
            Vector velocity = e.getEntity().getVelocity();
            e.getEntity().setVelocity(new Vector(velocity.getX(), 0.1, velocity.getZ()));
            e.setCancelled(true);
        }
        if ((sfItem = e.getEntity()) instanceof Player) {
            Boat boat;
            Player p = (Player)sfItem;
            Entity entity2 = p.getVehicle();
            if (entity2 instanceof Boat && (boat = (Boat)entity2).hasMetadata("lava_boat") && e.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                e.setCancelled(true);
                p.setFireTicks(0);
            }
            if (p.isInsideVehicle() && (entity2 = p.getVehicle()) instanceof Boat && (boat = (Boat)entity2).hasMetadata("lava_boat") && (e.getCause() == EntityDamageEvent.DamageCause.LAVA || e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
                e.setCancelled(true);
                p.setFireTicks(0);
            }
        }
    }

    @EventHandler
    public void onExit(final @NotNull VehicleExitEvent e) {
        Boat boat;
        Vehicle vehicle = e.getVehicle();
        if (vehicle instanceof Boat && (boat = (Boat)vehicle).hasMetadata("lava_boat")) {
            Location boatLocation = e.getVehicle().getLocation();
            Location teleportLocation = boatLocation.clone().add(0.0, 1.0, 0.0);
            e.getExited().teleport(teleportLocation);
            new BukkitRunnable(this){

                public void run() {
                    e.getExited().setFireTicks(0);
                }
            }.runTaskLater((Plugin)IDreamOfEasy.getInstance().getJavaPlugin(), 1L);
        }
    }
}

