/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Panda;

public final class PandaHelper {
    @Nonnull
    public static String getGene(@Nonnull Panda.Gene gene) {
        return Gene.fromGene(gene).getChinese();
    }

    @Nonnull
    public static String getGene(@Nonnull String gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"\u718a\u732b\u57fa\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Panda.Gene pandaGene = Panda.Gene.valueOf((String)gene);
            return Gene.fromGene(pandaGene).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(gene);
        }
    }

    private PandaHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Gene {
        AGGRESSIVE(Panda.Gene.AGGRESSIVE, "\u597d\u6597"),
        BROWN(Panda.Gene.BROWN, "\u68d5\u8272"),
        LAZY(Panda.Gene.LAZY, "\u61d2\u60f0"),
        NORMAL(Panda.Gene.NORMAL, "\u666e\u901a"),
        PLAYFUL(Panda.Gene.PLAYFUL, "\u987d\u76ae"),
        WEAK(Panda.Gene.WEAK, "\u865a\u5f31"),
        WORRIED(Panda.Gene.WORRIED, "\u53d1\u6101");

        private static final Gene[] cachedValues;
        private static final Map<Panda.Gene, Gene> geneLookup;
        private final Panda.Gene pandaGene;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Gene(Panda.Gene gene, String chinese) {
            this.pandaGene = gene;
            this.chinese = chinese;
        }

        @Nonnull
        public static Gene fromGene(@Nonnull Panda.Gene pandaGene) {
            Preconditions.checkArgument((pandaGene != null ? 1 : 0) != 0, (Object)"\u718a\u732b\u57fa\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
            for (Gene gene : Gene.values()) {
                if (gene.getPandaGene() != pandaGene) continue;
                return gene;
            }
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u718a\u732b\u57fa\u56e0");
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Panda.Gene getPandaGene() {
            return this.pandaGene;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Gene.values();
            geneLookup = new EnumMap<Panda.Gene, Gene>(Panda.Gene.class);
            for (Gene gene : cachedValues) {
                geneLookup.put(gene.getPandaGene(), gene);
            }
        }
    }
}

