/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.slimefun.items.core;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;

public enum AdvancedMetal {
    STEEL("Steel", "\u94a2"),
    BRONZE("Bronze", "\u9752\u94dc"),
    DURALUMIN("Duralumin", "\u786c\u94dd"),
    BILLON("Billon", "\u94f6\u94dc\u5408\u91d1"),
    BRASS("Brass", "\u9ec4\u94dc"),
    ALUMINUM_BRASS("Aluminum Brass", "\u94dd\u9ec4\u94dc"),
    ALUMINUM_BRONZE("Aluminum Bronze", "\u94dd\u9752\u94dc"),
    CORINTHIAN_BRONZE("Corinthian Bronze", "\u79d1\u6797\u65af\u9752\u94dc"),
    SOLDER("Solder", "\u710a\u9521"),
    DAMASCUS_STEEL("Damascus Steel", "\u5927\u9a6c\u58eb\u9769\u94a2"),
    HARDENED_METAL("Hardened Metal", "\u786c\u5316\u91d1\u5c5e"),
    REINFORCED_ALLOY("Reinforced Alloy", "\u5f3a\u5316\u5408\u91d1"),
    FERROSILICON("Ferrosilicon", "\u7845\u94c1", "FERROSILICON"),
    GILDED_IRON("Gilded Iron", "\u9540\u91d1\u94c1", "GILDED_IRON"),
    REDSTONE_ALLOY("Redstone Alloy", "\u7ea2\u77f3\u5408\u91d1", "REDSTONE_ALLOY"),
    NICKEL("Nickel", "\u954d"),
    COBALT("Cobalt", "\u94b4");

    private static final AdvancedMetal[] valuesCache;
    private static final Map<String, AdvancedMetal> englishLookup;
    private static final Map<String, AdvancedMetal> chineseLookup;
    private static final Map<String, AdvancedMetal> slimefunIdLookup;
    private final String english;
    private final String chinese;
    private final String slimefunId;

    @ParametersAreNonnullByDefault
    private AdvancedMetal(String english, String chinese, String slimefunId) {
        this.english = english;
        this.chinese = chinese;
        this.slimefunId = slimefunId;
    }

    @ParametersAreNonnullByDefault
    private AdvancedMetal(String english, String chinese) {
        this.english = english;
        this.chinese = chinese;
        this.slimefunId = StringUtil.dehumanize(english) + "_INGOT";
    }

    @Nullable
    public static AdvancedMetal fromEnglish(@Nonnull String english) {
        Preconditions.checkArgument((english != null ? 1 : 0) != 0, (Object)"\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        return englishLookup.get(StringUtil.humanize(english));
    }

    @Nullable
    public static AdvancedMetal fromChinese(@Nonnull String chinese) {
        Preconditions.checkArgument((chinese != null ? 1 : 0) != 0, (Object)"\u4e2d\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        return chineseLookup.get(chinese);
    }

    @Nullable
    public static AdvancedMetal fromSlimefunId(@Nonnull String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        return slimefunIdLookup.get(id);
    }

    @Nonnull
    public String toString() {
        return this.getChinese();
    }

    public String getEnglish() {
        return this.english;
    }

    public String getChinese() {
        return this.chinese;
    }

    public String getSlimefunId() {
        return this.slimefunId;
    }

    static {
        valuesCache = AdvancedMetal.values();
        englishLookup = new HashMap<String, AdvancedMetal>();
        chineseLookup = new HashMap<String, AdvancedMetal>();
        slimefunIdLookup = new HashMap<String, AdvancedMetal>();
        for (AdvancedMetal metal : valuesCache) {
            englishLookup.put(metal.getEnglish(), metal);
            chineseLookup.put(metal.getChinese(), metal);
            slimefunIdLookup.put(metal.getSlimefunId(), metal);
        }
    }
}

