/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.RadiationTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.RadiationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class RadiationAbsorber
extends SlimefunItem
implements EnergyNetComponent {
    private static final int GRACE_PERIOD = Slimefun.getCfg().getInt("options.radiation-grace-period");
    private final Map<UUID, Long> cd = new HashMap<UUID, Long>();
    private final Map<UUID, BossBar> bars = new HashMap<UUID, BossBar>();
    private static final Set<UUID> prot = new HashSet<UUID>();
    private final int cap;
    private final int ecost;
    private BukkitRunnable cdTask;

    public RadiationAbsorber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, final int ecost, int cap, final int range) {
        super(itemGroup, item, recipeType, recipe);
        this.cap = cap;
        this.ecost = ecost;
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            public void onPlayerBreak(@NotNull BlockBreakEvent e, @NotNull ItemStack stack, @NotNull List<ItemStack> list) {
                for (UUID pUUID : prot) {
                    Player p = Bukkit.getPlayer((UUID)pUUID);
                    if (p == null) continue;
                    BossBar bar = RadiationAbsorber.this.bars.get(pUUID);
                    if (bar != null) {
                        bar.removePlayer(p);
                    }
                    prot.remove(pUUID);
                    RadiationAbsorber.this.bars.remove(pUUID);
                }
                if (RadiationAbsorber.this.cdTask != null) {
                    RadiationAbsorber.this.cdTask.cancel();
                    RadiationAbsorber.this.cdTask = null;
                }
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem sfItem, Config config) {
                Location loc = b.getLocation();
                World w = loc.getWorld();
                if (w == null || RadiationAbsorber.this.getCharge(loc) < ecost) {
                    return;
                }
                RadiationAbsorber.this.nearbyPlayers(loc, range);
            }
        }});
    }

    private void nearbyPlayers(Location loc, int range) {
        Bukkit.getScheduler().runTask((Plugin)IDreamOfEasy.getInstance(), () -> {
            for (Player p : loc.getNearbyPlayers((double)range)) {
                if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, loc, Interaction.INTERACT_BLOCK) || !this.eligible(p) || this.getCharge(loc) < this.ecost) continue;
                this.protect(loc, p);
                IDOEUtility.spawnBeam(p, loc);
            }
        });
    }

    private boolean eligible(Player p) {
        UUID pUUID = p.getUniqueId();
        long curr = System.currentTimeMillis();
        return p.getGameMode() == GameMode.SURVIVAL && (!this.cd.containsKey(pUUID) || curr - this.cd.get(pUUID) >= (long)GRACE_PERIOD * 1000L) && !prot.contains(pUUID);
    }

    private void protect(Location loc, Player p) {
        UUID pUUID = p.getUniqueId();
        long curr = System.currentTimeMillis();
        RadiationTask.addGracePeriod((Player)p);
        RadiationUtils.clearExposure((Player)p);
        RadiationUtils.removeExposure((Player)p, (int)RadiationUtils.getExposure((Player)p));
        this.cd.put(pUUID, curr);
        prot.add(pUUID);
        BossBar bar = this.bars.computeIfAbsent(pUUID, uuid -> IDOEUtility.createBossBar(p));
        this.countdown(loc, bar, p);
    }

    private void countdown(final Location loc, final BossBar bar, final Player p) {
        this.cdTask = new BukkitRunnable(){
            long cd = GRACE_PERIOD;

            public void run() {
                RadiationAbsorber.this.removeCharge(loc, RadiationAbsorber.this.ecost);
                loc.getWorld().spawnParticle(Particle.ITEM_SLIME, loc.clone().add(0.5, 0.5, 0.5), 5, 0.5, 0.5, 0.5, 0.0);
                double progress = (double)this.cd / (double)GRACE_PERIOD;
                bar.setProgress(progress);
                if (this.cd > 0L) {
                    --this.cd;
                } else {
                    bar.removeAll();
                    prot.remove(p.getUniqueId());
                    RadiationAbsorber.this.bars.remove(p.getUniqueId());
                    this.cancel();
                }
            }
        };
        this.cdTask.runTaskTimer((Plugin)IDreamOfEasy.getInstance(), 0L, 20L);
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.cap;
    }
}

