/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.machines.repellers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class MobRepeller
extends SlimefunItem
implements Listener,
EnergyNetComponent {
    private final Set<String> repellerChunks = new HashSet<String>();
    private final int cap;
    private final int ecost;

    public MobRepeller(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, final int ecost, int cap) {
        super(itemGroup, item, recipeType, recipe);
        IDreamOfEasy.getInstance().getJavaPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)IDreamOfEasy.getInstance());
        this.cap = cap;
        this.ecost = ecost;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem sfItem, Config config) {
                Location loc = b.getLocation();
                World w = loc.getWorld();
                if (w == null) {
                    return;
                }
                if (MobRepeller.this.getCharge(loc) >= ecost) {
                    MobRepeller.this.removeCharge(loc, ecost);
                    Chunk chunk = b.getChunk();
                    String chunkKey = MobRepeller.this.getChunkKey(chunk);
                    if (!MobRepeller.this.repellerChunks.contains(chunkKey)) {
                        MobRepeller.this.repellerChunks.add(chunkKey);
                    }
                } else {
                    Chunk chunk = b.getChunk();
                    String chunkKey = MobRepeller.this.getChunkKey(chunk);
                    if (MobRepeller.this.repellerChunks.contains(chunkKey)) {
                        MobRepeller.this.repellerChunks.remove(chunkKey);
                    }
                }
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@NotNull BlockPlaceEvent blockPlaceEvent) {
                Block b = blockPlaceEvent.getBlock();
                Chunk chunk = b.getChunk();
                String chunkKey = MobRepeller.this.getChunkKey(chunk);
                MobRepeller.this.repellerChunks.add(chunkKey);
                blockPlaceEvent.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + MobRepeller.this.getRepelledEntityName() + "\u00a7es will no longer spawn in this chunk.");
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            public void onPlayerBreak(@NotNull BlockBreakEvent blockBreakEvent, @NotNull ItemStack itemStack, @NotNull List<ItemStack> list) {
                Block b = blockBreakEvent.getBlock();
                Chunk chunk = b.getChunk();
                String chunkKey = MobRepeller.this.getChunkKey(chunk);
                MobRepeller.this.repellerChunks.remove(chunkKey);
                blockBreakEvent.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + MobRepeller.this.getRepelledEntityName() + "\u00a7es may now spawn in this chunk.");
            }
        }});
    }

    protected abstract EntityType getRepelledEntityType();

    protected abstract String getRepelledEntityName();

    private String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        Chunk chunk;
        String chunkKey;
        if (e.getEntityType() == this.getRepelledEntityType() && this.repellerChunks.contains(chunkKey = this.getChunkKey(chunk = e.getLocation().getChunk()))) {
            e.setCancelled(true);
        }
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.cap;
    }
}

