/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.utils.compatibility;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import org.bukkit.potion.PotionType;

public final class PotionTypeX {
    public static final PotionType LEAPING;
    public static final PotionType SWIFTNESS;
    public static final PotionType HEALING;
    public static final PotionType HARMING;
    public static final PotionType REGENERATION;

    @Nullable
    private static PotionType getField(@Nonnull String key) {
        try {
            Field field = PotionType.class.getDeclaredField(key);
            return (PotionType)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private PotionTypeX() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean isAtLeast1_20_5 = MinecraftVersionUtil.isAtLeast(20, 5);
        LEAPING = isAtLeast1_20_5 ? PotionType.LEAPING : PotionTypeX.getField("JUMP");
        SWIFTNESS = isAtLeast1_20_5 ? PotionType.SWIFTNESS : PotionTypeX.getField("SPEED");
        HEALING = isAtLeast1_20_5 ? PotionType.HEALING : PotionTypeX.getField("INSTANT_HEAL");
        HARMING = isAtLeast1_20_5 ? PotionType.HARMING : PotionTypeX.getField("INSTANT_DAMAGE");
        REGENERATION = isAtLeast1_20_5 ? PotionType.REGENERATION : PotionTypeX.getField("REGEN");
    }
}

