/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Frog;

public final class FrogHelper {
    @Nonnull
    public static String getVariant(@Nonnull Frog.Variant variant) {
        return Variant.fromVariant(variant).getChinese();
    }

    @Nonnull
    public static String getVariant(@Nonnull String variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"\u9752\u86d9\u80a4\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Frog.Variant frogVariant = Frog.Variant.valueOf((String)variant);
            return Variant.fromVariant(frogVariant).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(variant);
        }
    }

    private FrogHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Variant {
        TEMPERATE(Frog.Variant.TEMPERATE, "\u6a59\u8272"),
        COLD(Frog.Variant.COLD, "\u7eff\u8272"),
        WARM(Frog.Variant.WARM, "\u767d\u8272");

        private static final Variant[] cachedValues;
        private static final Map<Frog.Variant, Variant> variantLookup;
        private final Frog.Variant frogVariant;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Variant(Frog.Variant variant, String chinese) {
            this.frogVariant = variant;
            this.chinese = chinese;
        }

        @Nonnull
        public static Variant fromVariant(@Nonnull Frog.Variant frogVariant) {
            Preconditions.checkArgument((frogVariant != null ? 1 : 0) != 0, (Object)"\u9752\u86d9\u80a4\u8272\u4e0d\u80fd\u4e3a\u7a7a");
            return variantLookup.get(frogVariant);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Frog.Variant getFrogVariant() {
            return this.frogVariant;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Variant.values();
            variantLookup = new EnumMap<Frog.Variant, Variant>(Frog.Variant.class);
            for (Variant variant : cachedValues) {
                variantLookup.put(variant.getFrogVariant(), variant);
            }
        }
    }
}

