/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashSet;
import javax.annotation.Nonnull;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.slimefun.items.idols.DivineIdol;
import me.bunnky.idreamofeasy.slimefun.items.idols.Idol;
import me.bunnky.idreamofeasy.slimefun.items.idols.TerranIdol;
import me.bunnky.idreamofeasy.slimefun.items.idols.TorrentIdol;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class IdolListener
implements Listener {
    public IdolListener(@Nonnull IDreamOfEasy plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            triggeredIdols = new HashSet();
            for (Idol idol : Idol.getIdols()) {
                if (!triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
                idol.trigger(p, (Event)e);
            }
        } else {
            Item item;
            SlimefunItem sfItem;
            triggeredIdols = e.getEntity();
            if (triggeredIdols instanceof Item && (sfItem = SlimefunItem.getByItem((ItemStack)(item = (Item)triggeredIdols).getItemStack())) instanceof Idol) {
                Vector velocity = e.getEntity().getVelocity();
                e.getEntity().setVelocity(new Vector(velocity.getX(), 0.1, velocity.getZ()));
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent e) {
        Player p;
        if (!(e.getEntity() instanceof Player) && (p = e.getEntity().getKiller()) != null) {
            HashSet triggeredIdols = new HashSet();
            for (Idol idol : Idol.getIdols()) {
                if (!(idol instanceof TerranIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
                idol.trigger(p, (Event)e);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        HashSet triggeredIdols = new HashSet();
        for (Idol idol : Idol.getIdols()) {
            if (!(idol instanceof TerranIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
            idol.trigger(e.getPlayer(), (Event)e);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnchantItem(EnchantItemEvent e) {
        HashSet triggeredIdols = new HashSet();
        for (Idol idol : Idol.getIdols()) {
            if (!(idol instanceof DivineIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
            idol.trigger(e.getEnchanter(), (Event)e);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerExpChange(PlayerExpChangeEvent e) {
        HashSet triggeredIdols = new HashSet();
        for (Idol idol : Idol.getIdols()) {
            if (!(idol instanceof DivineIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
            idol.trigger(e.getPlayer(), (Event)e);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerItemDamage(PlayerItemDamageEvent e) {
        HashSet triggeredIdols = new HashSet();
        for (Idol idol : Idol.getIdols()) {
            if (!(idol instanceof DivineIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
            idol.trigger(e.getPlayer(), (Event)e);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerSprint(PlayerToggleSprintEvent e) {
        HashSet triggeredIdols = new HashSet();
        for (Idol idol : Idol.getIdols()) {
            if (!(idol instanceof TorrentIdol) || !triggeredIdols.add(((Object)((Object)idol)).getClass())) continue;
            idol.trigger(e.getPlayer(), (Event)e);
            break;
        }
    }
}

