/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Axolotl;

public final class AxolotlHelper {
    @Nonnull
    public static String getVariant(@Nonnull Axolotl.Variant variant) {
        return Variant.fromType(variant).getChinese();
    }

    @Nonnull
    public static String getVariant(@Nonnull String variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"\u7f8e\u897f\u8788\u7684\u53d8\u79cd\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Axolotl.Variant axolotlVariant = Axolotl.Variant.valueOf((String)variant);
            return Variant.fromType(axolotlVariant).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(variant);
        }
    }

    private AxolotlHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Variant {
        LUCY(Axolotl.Variant.LUCY, "\u7c89\u7ea2\u8272"),
        WILD(Axolotl.Variant.WILD, "\u68d5\u8272"),
        GOLD(Axolotl.Variant.GOLD, "\u91d1\u8272"),
        CYAN(Axolotl.Variant.CYAN, "\u9752\u8272"),
        BLUE(Axolotl.Variant.BLUE, "\u84dd\u8272");

        private static final Variant[] cachedValues;
        private static final Map<Axolotl.Variant, Variant> variantLookup;
        private final Axolotl.Variant axolotlVariant;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Variant(Axolotl.Variant variant, String chinese) {
            this.axolotlVariant = variant;
            this.chinese = chinese;
        }

        @Nonnull
        public static Variant fromType(@Nonnull Axolotl.Variant axolotlVariant) {
            Preconditions.checkArgument((axolotlVariant != null ? 1 : 0) != 0, (Object)"\u7f8e\u897f\u8788\u53d8\u79cd\u4e0d\u80fd\u4e3a\u7a7a");
            return variantLookup.get(axolotlVariant);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Axolotl.Variant getAxolotlVariant() {
            return this.axolotlVariant;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Variant.values();
            variantLookup = new EnumMap<Axolotl.Variant, Variant>(Axolotl.Variant.class);
            for (Variant variant : cachedValues) {
                variantLookup.put(variant.getAxolotlVariant(), variant);
            }
        }
    }
}

