/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ElectricCable
extends SlimefunItem
implements EnergyNetComponent {
    private final int cap;
    private final int ecost;
    private final double damageAmount;
    private final double knockbackStrength;
    private final double range = 1.5;

    public ElectricCable(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput, final int ecost, int cap, double damageAmount, double knockbackStrength) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        this.cap = cap;
        this.ecost = ecost;
        this.damageAmount = damageAmount;
        this.knockbackStrength = knockbackStrength;
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem sfItem, Config config) {
                Location loc = b.getLocation();
                World w = loc.getWorld();
                if (w == null || ElectricCable.this.getCharge(loc) < ecost) {
                    return;
                }
                ElectricCable.this.removeCharge(loc, ecost);
                ElectricCable.this.nearbyEntities(loc);
            }
        }});
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(this, false){

            public void onPlayerPlace(@NotNull BlockPlaceEvent e) {
                Player p = e.getPlayer();
                Block b = e.getBlock();
                BlockStorage.addBlockInfo((Block)b, (String)"owner", (String)p.getUniqueId().toString());
            }
        };
    }

    private void nearbyEntities(Location loc) {
        Bukkit.getScheduler().runTask((Plugin)IDreamOfEasy.getInstance(), () -> {
            String ownerUUID = BlockStorage.getLocationInfo((Location)loc, (String)"owner");
            double minX = (double)loc.getBlockX() - 1.5;
            double maxX = (double)loc.getBlockX() + 1.5;
            double minY = loc.getBlockY() - 1;
            double maxY = loc.getBlockY() + 1;
            double minZ = (double)loc.getBlockZ() - 1.5;
            double maxZ = (double)loc.getBlockZ() + 1.5;
            for (Entity entity : loc.getNearbyEntities(1.5, 1.5, 1.5)) {
                if (!entity.getBoundingBox().overlaps(new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ)) || entity.getType() == EntityType.ITEM) continue;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.getGameMode() != GameMode.SURVIVAL || ownerUUID != null && player.getUniqueId().toString().equals(ownerUUID)) continue;
                    this.damage(loc, (Entity)player);
                    continue;
                }
                this.damage(loc, entity);
            }
        });
    }

    private void damage(Location loc, Entity entity) {
        if (this.getCharge(loc) >= this.ecost) {
            if (entity instanceof Damageable) {
                Damageable damageable = (Damageable)entity;
                damageable.damage(this.damageAmount);
            }
            Vector dir = entity.getLocation().toVector().subtract(loc.toVector()).normalize();
            dir.multiply(this.knockbackStrength);
            dir.setY(0.3);
            entity.setVelocity(dir);
            loc.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, loc.add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.1);
        }
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.cap;
    }
}

