/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items.idols;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Random;
import javax.annotation.Nonnull;
import me.bunnky.idreamofeasy.slimefun.items.idols.Idol;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class TorrentIdol
extends Idol {
    private final Random random = new Random();

    public TorrentIdol(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void handleEvent(Event event) {
        if (event instanceof EntityDamageEvent) {
            EntityDamageEvent e = (EntityDamageEvent)event;
            Entity entity = e.getEntity();
            if (entity instanceof Player) {
                Player p = (Player)entity;
                switch (e.getCause()) {
                    case DROWNING: {
                        if (!(this.random.nextDouble() < 0.2)) break;
                        p.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 200, 1));
                        this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7a+Water Breathing");
                        break;
                    }
                    case FALL: {
                        if (!(this.random.nextDouble() < 0.75)) break;
                        e.setCancelled(true);
                        this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aFall damage absorbed!");
                        break;
                    }
                    case PROJECTILE: {
                        EntityDamageByEntityEvent entity2;
                        Entity entity3;
                        if (!(e instanceof EntityDamageByEntityEvent) || !((entity3 = (entity2 = (EntityDamageByEntityEvent)e).getDamager()) instanceof Projectile)) break;
                        Projectile projectile = (Projectile)entity3;
                        if (entity2.getDamager() instanceof Trident || !(this.random.nextDouble() < 0.6)) break;
                        this.returnProjectile(p, projectile);
                        this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aProjectile reflected!");
                    }
                }
            }
        } else if (event instanceof PlayerToggleSprintEvent) {
            PlayerToggleSprintEvent e = (PlayerToggleSprintEvent)event;
            Player p = e.getPlayer();
            if (e.isSprinting() && !p.hasPotionEffect(PotionEffectType.SPEED) && this.random.nextDouble() < 0.6) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 1));
                this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7a+Speed II");
            }
        }
    }

    private void returnProjectile(@Nonnull Player p, @Nonnull Projectile projectile) {
        Vector direction = p.getEyeLocation().getDirection().multiply(2.0);
        Location loc = p.getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ());
        Projectile returnedProjectile = (Projectile)p.getWorld().spawnEntity(loc, projectile.getType());
        returnedProjectile.setShooter(projectile.getShooter());
        returnedProjectile.setVelocity(direction);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow firedArrow = (AbstractArrow)projectile;
            AbstractArrow returnedArrow = (AbstractArrow)returnedProjectile;
            returnedArrow.setDamage(firedArrow.getDamage());
            returnedArrow.setPickupStatus(firedArrow.getPickupStatus());
            returnedArrow.setPierceLevel(firedArrow.getPierceLevel());
        }
        projectile.remove();
    }
}

