/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.config;

import io.github.bakedlibs.dough.common.DoughLogger;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Config {
    private final File file;
    private Logger logger;
    private String header;
    protected FileConfiguration fileConfig;

    public Config(@Nonnull Plugin plugin) {
        plugin.getConfig().options().copyDefaults(true);
        plugin.saveConfig();
        this.logger = plugin.getLogger();
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), "config.yml");
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(@Nonnull Plugin plugin, @Nonnull String name) {
        this.logger = plugin.getLogger();
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), name);
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(@Nonnull File file, @Nonnull FileConfiguration config) {
        this.logger = new DoughLogger("config");
        this.file = file;
        this.fileConfig = config;
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(@Nonnull File file) {
        this(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
    }

    public Config(@Nonnull String path) {
        this(new File(path));
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nullable
    public String getHeader() {
        return this.header;
    }

    public void setHeader(@Nullable String header) {
        this.header = header;
    }

    @Nonnull
    public FileConfiguration getConfiguration() {
        return this.fileConfig;
    }

    public void setLogger(@Nonnull Logger logger) {
        this.logger = logger;
    }

    public void clear() {
        for (String key : this.getKeys()) {
            this.setValue(key, null);
        }
    }

    protected void store(@Nonnull String path, Object value) {
        this.fileConfig.set(path, value);
    }

    public void setValue(@Nonnull String path, Object value) {
        if (value == null) {
            this.store(path, value);
        } else if (value instanceof Optional) {
            this.store(path, ((Optional)value).orElse(null));
        } else if (value instanceof Inventory) {
            this.store(path + ".size", ((Inventory)value).getSize());
            for (int i = 0; i < ((Inventory)value).getSize(); ++i) {
                this.store(path + "." + i, ((Inventory)value).getItem(i));
            }
        } else if (value instanceof Date) {
            this.store(path, String.valueOf(((Date)value).getTime()));
        } else if (value instanceof Long) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof UUID) {
            this.store(path, value.toString());
        } else if (value instanceof Sound) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof Location) {
            this.store(path + ".x", ((Location)value).getX());
            this.store(path + ".y", ((Location)value).getY());
            this.store(path + ".z", ((Location)value).getZ());
            this.store(path + ".pitch", Float.valueOf(((Location)value).getPitch()));
            this.store(path + ".yaw", Float.valueOf(((Location)value).getYaw()));
            this.store(path + ".world", ((Location)value).getWorld().getName());
        } else if (value instanceof Chunk) {
            this.store(path + ".x", ((Chunk)value).getX());
            this.store(path + ".z", ((Chunk)value).getZ());
            this.store(path + ".world", ((Chunk)value).getWorld().getName());
        } else if (value instanceof World) {
            this.store(path, ((World)value).getName());
        } else {
            this.store(path, value);
        }
    }

    public void save() {
        this.save(this.file);
    }

    public void save(@Nonnull File file) {
        try {
            if (this.header != null) {
                this.fileConfig.options().copyHeader(true);
                this.fileConfig.options().header(this.header);
            } else {
                this.fileConfig.options().copyHeader(false);
            }
            this.fileConfig.save(file);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while saving a Config file", e);
        }
    }

    public void setDefaultValue(@Nonnull String path, @Nullable Object value) {
        if (!this.contains(path)) {
            this.setValue(path, value);
        }
    }

    public <T> T getOrSetDefault(@Nonnull String path, T value) {
        Object val2 = this.getValue(path);
        if (value.getClass().isInstance(val2)) {
            return (T)val2;
        }
        this.setValue(path, value);
        return value;
    }

    public boolean contains(@Nonnull String path) {
        return this.fileConfig.contains(path);
    }

    @Nullable
    public Object getValue(@Nonnull String path) {
        return this.fileConfig.get(path);
    }

    @Nonnull
    public <T> Optional<T> getValueAs(@Nonnull Class<T> c, @Nonnull String path) {
        Object obj = this.getValue(path);
        return c.isInstance(obj) ? Optional.of(c.cast(obj)) : Optional.empty();
    }

    @Nullable
    public ItemStack getItem(@Nonnull String path) {
        return this.fileConfig.getItemStack(path);
    }

    @Nullable
    public String getString(@Nonnull String path) {
        return this.fileConfig.getString(path);
    }

    public int getInt(@Nonnull String path) {
        return this.fileConfig.getInt(path);
    }

    public boolean getBoolean(@Nonnull String path) {
        return this.fileConfig.getBoolean(path);
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path) {
        return this.fileConfig.getStringList(path);
    }

    @Nonnull
    public List<Integer> getIntList(@Nonnull String path) {
        return this.fileConfig.getIntegerList(path);
    }

    public boolean createFile() {
        try {
            return this.file.createNewFile();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while creating a Config file", e);
            return false;
        }
    }

    public float getFloat(@Nonnull String path) {
        return Float.valueOf(String.valueOf(this.getValue(path))).floatValue();
    }

    public long getLong(@Nonnull String path) {
        return Long.valueOf(String.valueOf(this.getValue(path)));
    }

    public Date getDate(@Nonnull String path) {
        return new Date(this.getLong(path));
    }

    public Chunk getChunk(@Nonnull String path) {
        return Bukkit.getWorld((String)this.getString(path + ".world")).getChunkAt(this.getInt(path + ".x"), this.getInt(path + ".z"));
    }

    public UUID getUUID(@Nonnull String path) {
        String value = this.getString(path);
        return value != null ? UUID.fromString(value) : null;
    }

    public World getWorld(@Nonnull String path) {
        return Bukkit.getWorld((String)this.getString(path));
    }

    public double getDouble(@Nonnull String path) {
        return this.fileConfig.getDouble(path);
    }

    @Nonnull
    public Location getLocation(@Nonnull String path) {
        return new Location(Bukkit.getWorld((String)this.getString(path + ".world")), this.getDouble(path + ".x"), this.getDouble(path + ".y"), this.getDouble(path + ".z"), this.getFloat(path + ".yaw"), this.getFloat(path + ".pitch"));
    }

    @Nonnull
    public Inventory getInventory(@Nonnull String path, int size, @Nonnull String title) {
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    @Nonnull
    public Inventory getInventory(@Nonnull String path, @Nonnull String title) {
        int size = this.getInt(path + ".size");
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    @Nonnull
    public Set<String> getKeys() {
        return this.fileConfig.getKeys(false);
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull String path) {
        ConfigurationSection section = this.fileConfig.getConfigurationSection(path);
        return section == null ? new HashSet() : section.getKeys(false);
    }

    public void reload() {
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

