/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items.idols;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class Idol
extends SlimefunItem {
    private static final List<Idol> idols = new ArrayList<Idol>();
    private boolean messagingEnabled = true;

    public Idol(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        IDOEUtility.setGlow(item);
        idols.add(this);
        this.addItemHandler(new ItemHandler[]{e -> {
            Player player = e.getPlayer();
            this.messagingEnabled = !this.messagingEnabled;
            String idolName = this.getItemName();
            if (this.messagingEnabled) {
                player.sendMessage("\u00a72[IDreamOfEasy]\u00a7a " + idolName + " \u00a7amessages are now enabled");
            } else {
                player.sendMessage("\u00a72[IDreamOfEasy]\u00a7a " + idolName + " \u00a7cmessages are now disabled");
            }
        }});
    }

    public static List<Idol> getIdols() {
        return idols;
    }

    public boolean trigger(Player p, Event e) {
        if (this.checkIdol(p)) {
            this.handleEvent(e);
            return true;
        }
        return false;
    }

    protected abstract void handleEvent(Event var1);

    private boolean checkIdol(Player p) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack item : inv.getContents()) {
            Idol idol;
            SlimefunItem sfItem;
            if (item == null || !((sfItem = SlimefunItem.getByItem((ItemStack)item)) instanceof Idol) || (idol = (Idol)sfItem) != this) continue;
            return true;
        }
        return false;
    }

    protected void sendMessage(Player player, String message) {
        if (this.messagingEnabled) {
            player.sendActionBar((Component)Component.text((String)("\u00a72[IDreamOfEasy]\u00a7a " + message)));
        }
    }
}

