/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.DyeColor;

public final class DyeColorHelper {
    @Nonnull
    public static String getName(@Nonnull DyeColor dyeColor) {
        return LanguageHelper.getLangOrKey(DyeColorHelper.getKey(dyeColor));
    }

    @Nonnull
    public static String getKey(@Nonnull DyeColor dyeColor) {
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"\u67d3\u6599\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        return "color.minecraft." + dyeColor.toString().toLowerCase();
    }

    @Nonnull
    public static String getName(@Nonnull String dyeColor) {
        return DyeColorHelper.getName(dyeColor, false);
    }

    @Nonnull
    public static String getName(@Nonnull String dyeColor, boolean emptyString) {
        try {
            DyeColor color = DyeColor.valueOf((String)StringUtil.dehumanize(dyeColor));
            return DyeColorHelper.getName(color);
        }
        catch (IllegalArgumentException ex) {
            if (emptyString) {
                return StringUtil.humanize(dyeColor);
            }
            return "";
        }
    }

    private DyeColorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

