/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.tasks;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.bunnky.idreamofeasy.IDreamOfEasy;
import me.bunnky.idreamofeasy.slimefun.items.Magnetoid;
import me.bunnky.idreamofeasy.slimefun.listener.MagnetoidListener;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class MagnetoidTask
extends BukkitRunnable {
    private static final float COST = 0.01f;
    private final double r;
    private final Player p;
    private final Magnetoid magnetoid;

    public MagnetoidTask(@NotNull Player p, double r, @NotNull Magnetoid magnetoid) {
        this.r = r;
        this.p = p;
        this.magnetoid = magnetoid;
    }

    public void run() {
        if (!this.isValid()) {
            this.cancel();
            return;
        }
        ItemStack off = this.p.getInventory().getItemInOffHand();
        if (!SlimefunUtils.isItemSimilar((ItemStack)off, (ItemStack)this.magnetoid.getItem(), (boolean)true)) {
            MagnetoidListener.activeTasks.remove(this.p.getUniqueId());
            this.cancel();
            return;
        }
        if (!this.p.isSneaking()) {
            for (Entity ent : this.p.getNearbyEntities(this.r, this.r, this.r)) {
                Item i;
                if (!(ent instanceof Item) || !this.isValidItem(i = (Item)ent) || i.hasMetadata("tp") || !this.magnetoid.removeItemCharge(off, 0.01f)) continue;
                i.teleport(this.p.getLocation());
                this.p.playSound((Entity)this.p, Sound.BLOCK_AMETHYST_BLOCK_STEP, SoundCategory.PLAYERS, 0.2f, 0.2f);
                i.setMetadata("tp", (MetadataValue)new FixedMetadataValue((Plugin)IDreamOfEasy.getInstance(), (Object)true));
                Bukkit.getScheduler().runTaskLater((Plugin)IDreamOfEasy.getInstance(), () -> i.removeMetadata("tp", (Plugin)IDreamOfEasy.getInstance()), 10L);
            }
        }
    }

    protected boolean isValid() {
        return this.p.isOnline() || this.p.getGameMode() != GameMode.SPECTATOR;
    }

    private boolean isValidItem(Item i) {
        return !i.isDead() && !SlimefunUtils.hasNoPickupFlag((Item)i) && i.getPickupDelay() <= 0 && this.p.getLocation().distanceSquared(i.getLocation()) > 0.3;
    }
}

