/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items.idols;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Map;
import java.util.Random;
import me.bunnky.idreamofeasy.slimefun.items.idols.Idol;
import net.guizhanss.guizhanlib.minecraft.utils.compatibility.EnchantmentX;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;

public class DivineIdol
extends Idol {
    private final Random random = new Random();

    public DivineIdol(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void handleEvent(Event e) {
        if (e instanceof EnchantItemEvent) {
            this.onEnchant((EnchantItemEvent)e);
        } else if (e instanceof PlayerExpChangeEvent) {
            this.onPlayerExperience((PlayerExpChangeEvent)e);
        } else if (e instanceof PlayerItemDamageEvent) {
            this.onItemDamage((PlayerItemDamageEvent)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnchant(EnchantItemEvent e) {
        Player p = e.getEnchanter();
        ItemStack item = e.getItem();
        Material type = item.getType();
        if (this.random.nextDouble() < 0.8) {
            Map enchantments = e.getEnchantsToAdd();
            enchantments.replaceAll((enchantment, level) -> Math.min(level + 1, enchantment.getMaxLevel()));
            this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aEnhanced enchants!");
            if ((Tag.ITEMS_PICKAXES.isTagged((Keyed)type) || Tag.ITEMS_SHOVELS.isTagged((Keyed)type) || Tag.ITEMS_AXES.isTagged((Keyed)type) || Tag.ITEMS_HOES.isTagged((Keyed)type)) && this.random.nextDouble() < 0.2) {
                enchantments.put(EnchantmentX.FORTUNE, this.random.nextInt(3) + 1);
                this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aAdded Fortune II!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerExperience(PlayerExpChangeEvent e) {
        Player p = e.getPlayer();
        if (this.random.nextDouble() < 0.2) {
            e.setAmount(e.getAmount() * 2);
            this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aDoubled exp!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        if (this.random.nextDouble() < 0.2 && item.getDurability() >= item.getType().getMaxDurability() - 1) {
            e.setCancelled(true);
            item.setDurability((short)0);
            this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7asaved " + item.getItemMeta().getDisplayName() + "\u00a7r\u00a7a!");
        }
    }
}

