/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import org.bukkit.entity.EntityType;

public final class EntityTypeHelper {
    @Nonnull
    public static String getName(@Nonnull EntityType entityType) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return LanguageHelper.getLangOrKey(EntityTypeHelper.getKey(entityType));
    }

    @Nonnull
    public static String getKey(@Nonnull EntityType entityType) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (Object)"\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u65e0\u6548\u7c7b\u578b");
        return "entity.minecraft." + entityType.getName().toLowerCase();
    }

    @Nonnull
    public static String getName(@Nonnull String entityType) {
        try {
            EntityType type = EntityType.valueOf((String)entityType);
            return EntityTypeHelper.getName(type);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    private EntityTypeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

